/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.execution.taskgraph.DefaultTaskPlanExecutor;
import org.gradle.execution.taskgraph.ExecutionOptions;
import org.gradle.execution.taskgraph.ParallelTaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.internal.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPlanExecutorFactory
implements Factory<TaskPlanExecutor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskPlanExecutorFactory.class);
    private final TaskArtifactStateCacheAccess taskArtifactStateCacheAccess;
    private final int parallelThreads;
    private final DocumentationRegistry documentationRegistry;

    public TaskPlanExecutorFactory(TaskArtifactStateCacheAccess taskArtifactStateCacheAccess, int parallelThreads, DocumentationRegistry documentationRegistry) {
        this.taskArtifactStateCacheAccess = taskArtifactStateCacheAccess;
        this.parallelThreads = parallelThreads;
        this.documentationRegistry = documentationRegistry;
    }

    public TaskPlanExecutor create() {
        ExecutionOptions options = new ExecutionOptions(this.parallelThreads);
        if (options.executeProjectsInParallel()) {
            String parallelWarningMessage = String.format("Parallel project execution is an \"incubating\" feature (%s). Many builds will not run correctly with this option.", this.documentationRegistry.getFeatureLifecycle());
            LOGGER.warn(parallelWarningMessage);
            return new ParallelTaskPlanExecutor(this.taskArtifactStateCacheAccess, options.numberOfParallelThreads());
        }
        return new DefaultTaskPlanExecutor();
    }
}

