/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.Set;
import org.gradle.api.internal.TaskInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskInfo {
    private final TaskInternal task;
    private final Set<TaskInfo> dependencies;
    private TaskExecutionState state;
    private Throwable executionFailure;

    public TaskInfo(TaskInternal task, Set<TaskInfo> dependencies) {
        this.task = task;
        this.dependencies = dependencies;
        this.state = TaskExecutionState.READY;
    }

    public TaskInternal getTask() {
        return this.task;
    }

    public Set<TaskInfo> getDependencies() {
        return this.dependencies;
    }

    public boolean isReady() {
        return this.state == TaskExecutionState.READY;
    }

    public boolean isComplete() {
        return this.state == TaskExecutionState.EXECUTED || this.state == TaskExecutionState.SKIPPED;
    }

    public boolean isSuccessful() {
        return this.state == TaskExecutionState.EXECUTED && !this.isFailed();
    }

    public boolean isFailed() {
        return this.getTaskFailure() != null || this.getExecutionFailure() != null;
    }

    public void startExecution() {
        assert (this.state == TaskExecutionState.READY);
        this.state = TaskExecutionState.EXECUTING;
    }

    public void finishExecution() {
        assert (this.state == TaskExecutionState.EXECUTING);
        this.state = TaskExecutionState.EXECUTED;
    }

    public void skipExecution() {
        assert (this.state == TaskExecutionState.READY);
        this.state = TaskExecutionState.SKIPPED;
    }

    public void setExecutionFailure(Throwable failure) {
        assert (this.state == TaskExecutionState.EXECUTING);
        this.executionFailure = failure;
    }

    public Throwable getExecutionFailure() {
        return this.executionFailure;
    }

    public Throwable getTaskFailure() {
        return this.getTask().getState().getFailure();
    }

    public boolean allDependenciesComplete() {
        for (TaskInfo dependency : this.getDependencies()) {
            if (dependency.isComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean allDependenciesSuccessful() {
        for (TaskInfo dependency : this.getDependencies()) {
            if (dependency.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskExecutionState {
        READY,
        EXECUTING,
        EXECUTED,
        SKIPPED;

    }
}

