/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.commandline;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.execution.TaskSelector;
import org.gradle.execution.commandline.CommandLineTaskConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineTaskParser {
    CommandLineTaskConfigurer taskConfigurer = new CommandLineTaskConfigurer();

    public Multimap<String, Task> parseTasks(List<String> taskPaths, TaskSelector taskSelector) {
        this.validateTaskPaths(taskPaths);
        LinkedHashMultimap out = LinkedHashMultimap.create();
        List<String> remainingPaths = new LinkedList<String>(taskPaths);
        while (!remainingPaths.isEmpty()) {
            String path = (String)remainingPaths.remove(0);
            TaskSelector.TaskSelection selection = taskSelector.getSelection(path);
            Set<Task> tasks = selection.getTasks();
            remainingPaths = this.taskConfigurer.configureTasks(tasks, remainingPaths);
            out.putAll((Object)selection.getTaskName(), tasks);
        }
        return out;
    }

    private void validateTaskPaths(List<String> taskPaths) {
        LinkedList<String> invalidTasks = new LinkedList<String>();
        for (String path : taskPaths) {
            if (!path.startsWith("-") || path.startsWith("--")) continue;
            invalidTasks.add(path);
        }
        if (!invalidTasks.isEmpty()) {
            throw new GradleException("Incorrect command line arguments: " + invalidTasks + ". Task options require double dash, for example: 'gradle tasks --all'.");
        }
    }
}

