/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.cache.CacheAccess;
import org.gradle.cache.DefaultSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultCacheAccess
implements CacheAccess {
    private final String cacheDiplayName;
    private final File lockFile;
    private final FileLockManager lockManager;
    private final FileAccess fileAccess = new UnitOfWorkFileAccess();
    private final Set<MultiProcessSafePersistentIndexedCache<?, ?>> caches = new HashSet();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private Thread owner;
    private FileLockManager.LockMode lockMode;
    private FileLock fileLock;
    private final ThreadLocal<CacheOperationStack> operationStack = new ThreadLocal<CacheOperationStack>(){

        @Override
        protected CacheOperationStack initialValue() {
            return new CacheOperationStack();
        }
    };

    public DefaultCacheAccess(String cacheDisplayName, File lockFile, FileLockManager lockManager) {
        this.cacheDiplayName = cacheDisplayName;
        this.lockFile = lockFile;
        this.lockManager = lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(FileLockManager.LockMode lockMode) {
        this.lock.lock();
        try {
            if (this.owner != null) {
                throw new IllegalStateException(String.format("Cannot open the %s, as it is already in use.", this.cacheDiplayName));
            }
            this.lockMode = lockMode;
            if (lockMode == FileLockManager.LockMode.None) {
                return;
            }
            this.fileLock = this.lockManager.lock(this.lockFile, lockMode, this.cacheDiplayName);
            this.takeOwnership(String.format("Access %s", this.cacheDiplayName));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block7: {
            this.lock.lock();
            try {
                for (MultiProcessSafePersistentIndexedCache<?, ?> cache : this.caches) {
                    cache.close();
                }
                this.operationStack.remove();
                this.lockMode = null;
                this.owner = null;
                if (this.fileLock == null) break block7;
                try {
                    this.fileLock.close();
                }
                finally {
                    this.fileLock = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public FileLock getFileLock() {
        return this.fileLock;
    }

    @Override
    public void useCache(String operationDisplayName, Runnable action) {
        this.useCache(operationDisplayName, Factories.toFactory((Runnable)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T useCache(String operationDisplayName, Factory<? extends T> factory) {
        if (this.lockMode == FileLockManager.LockMode.Shared) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        this.takeOwnership(operationDisplayName);
        try {
            Object object;
            block8: {
                boolean wasStarted = this.onStartWork();
                try {
                    object = factory.create();
                    if (!wasStarted) break block8;
                    this.onEndWork();
                }
                catch (Throwable throwable) {
                    if (wasStarted) {
                        this.onEndWork();
                    }
                    throw throwable;
                }
            }
            return (T)object;
        }
        finally {
            this.releaseOwnership(operationDisplayName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeOwnership(String operationDisplayName) {
        this.lock.lock();
        try {
            while (this.owner != null && this.owner != Thread.currentThread()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            this.owner = Thread.currentThread();
            this.operationStack.get().pushCacheAction(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseOwnership(String operationDisplayName) {
        this.lock.lock();
        try {
            this.operationStack.get().popCacheAction(operationDisplayName);
            if (!this.operationStack.get().isInCacheAction()) {
                this.owner = null;
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
        if (this.operationStack.get().isInLongRunningOperation()) {
            this.operationStack.get().pushLongRunningOperation(operationDisplayName);
            try {
                Object object = action.create();
                return (T)object;
            }
            finally {
                this.operationStack.get().popLongRunningOperation(operationDisplayName);
            }
        }
        this.checkThreadIsOwner();
        boolean wasEnded = this.onEndWork();
        this.parkOwner(operationDisplayName);
        try {
            Object object = action.create();
            return (T)object;
        }
        finally {
            this.restoreOwner(operationDisplayName);
            if (wasEnded) {
                this.onStartWork();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkThreadIsOwner() {
        this.lock.lock();
        try {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException(String.format("Cannot start long running operation, as the %s has not been locked.", this.cacheDiplayName));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parkOwner(String operationDisplayName) {
        this.lock.lock();
        try {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException(String.format("Cannot start long running operation, as the %s has not been locked.", this.cacheDiplayName));
            }
            this.owner = null;
            this.condition.signalAll();
            this.operationStack.get().pushLongRunningOperation(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreOwner(String description) {
        this.lock.lock();
        try {
            while (this.owner != null) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            this.owner = Thread.currentThread();
            this.operationStack.get().popLongRunningOperation(description);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void longRunningOperation(String operationDisplayName, Runnable action) {
        this.longRunningOperation(operationDisplayName, Factories.toFactory((Runnable)action));
    }

    public <K, V> PersistentIndexedCache<K, V> newCache(File cacheFile, Class<K> keyType, Class<V> valueType) {
        return this.newCache(cacheFile, keyType, new DefaultSerializer(valueType.getClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> PersistentIndexedCache<K, V> newCache(final File cacheFile, final Class<K> keyType, final Serializer<V> valueSerializer) {
        Factory indexedCacheFactory = new Factory<BTreePersistentIndexedCache<K, V>>(){

            public BTreePersistentIndexedCache<K, V> create() {
                return DefaultCacheAccess.this.doCreateCache(cacheFile, new DefaultSerializer(keyType.getClassLoader()), valueSerializer);
            }
        };
        MultiProcessSafePersistentIndexedCache indexedCache = new MultiProcessSafePersistentIndexedCache(indexedCacheFactory, this.fileAccess);
        this.lock.lock();
        try {
            this.caches.add(indexedCache);
            if (this.fileLock != null) {
                indexedCache.onStartWork(this.operationStack.get().getDescription());
            }
        }
        finally {
            this.lock.unlock();
        }
        return indexedCache;
    }

    <K, V> BTreePersistentIndexedCache<K, V> doCreateCache(File cacheFile, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new BTreePersistentIndexedCache<K, V>(cacheFile, keySerializer, valueSerializer);
    }

    private boolean onStartWork() {
        if (this.fileLock != null) {
            return false;
        }
        this.fileLock = this.lockManager.lock(this.lockFile, FileLockManager.LockMode.Exclusive, this.cacheDiplayName, this.operationStack.get().getDescription());
        for (MultiProcessSafePersistentIndexedCache<?, ?> cache : this.caches) {
            cache.onStartWork(this.operationStack.get().getDescription());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onEndWork() {
        if (this.fileLock == null) {
            return false;
        }
        try {
            for (MultiProcessSafePersistentIndexedCache<?, ?> cache : this.caches) {
                cache.onEndWork();
            }
            this.fileLock.close();
        }
        finally {
            this.fileLock = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock getLock() {
        this.lock.lock();
        try {
            if (Thread.currentThread() != this.owner || this.fileLock == null) {
                throw new IllegalStateException(String.format("The %s has not been locked.", this.cacheDiplayName));
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.fileLock;
    }

    private class CacheOperation {
        final String description;
        final boolean longRunningOperation;

        private CacheOperation(String description, boolean longRunningOperation) {
            this.description = description;
            this.longRunningOperation = longRunningOperation;
        }
    }

    private class CacheOperationStack {
        private final List<CacheOperation> operations = new ArrayList<CacheOperation>();

        private CacheOperationStack() {
        }

        public String getDescription() {
            this.checkNotEmpty();
            return this.operations.get((int)0).description;
        }

        public boolean isInLongRunningOperation() {
            return !this.operations.isEmpty() && this.operations.get((int)0).longRunningOperation;
        }

        public void pushLongRunningOperation(String description) {
            this.operations.add(0, new CacheOperation(description, true));
        }

        public void popLongRunningOperation(String description) {
            this.pop(description, true);
        }

        public boolean isInCacheAction() {
            return !this.operations.isEmpty() && !this.operations.get((int)0).longRunningOperation;
        }

        public void pushCacheAction(String description) {
            this.operations.add(0, new CacheOperation(description, false));
        }

        public void popCacheAction(String description) {
            this.pop(description, false);
        }

        private CacheOperation pop(String description, boolean longRunningOperation) {
            this.checkNotEmpty();
            CacheOperation operation = this.operations.remove(0);
            if (operation.description.equals(description) && operation.longRunningOperation == longRunningOperation) {
                return operation;
            }
            throw new IllegalStateException();
        }

        private void checkNotEmpty() {
            if (this.operations.isEmpty()) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnitOfWorkFileAccess
    extends AbstractFileAccess {
        private UnitOfWorkFileAccess() {
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException {
            return DefaultCacheAccess.this.getLock().readFile(action);
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().updateFile(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().writeFile(action);
        }
    }
}

