/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.specs;

import groovy.lang.Closure;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.OrSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.internal.ClosureSpec;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Specs {
    public static final Spec<Object> SATISFIES_ALL = new Spec<Object>(){

        public boolean isSatisfiedBy(Object element) {
            return true;
        }
    };
    public static final Spec<Object> SATISFIES_NONE = new Spec<Object>(){

        public boolean isSatisfiedBy(Object element) {
            return false;
        }
    };

    public static <T> Spec<T> satisfyAll() {
        return SATISFIES_ALL;
    }

    public static <T> Spec<T> satisfyNone() {
        return SATISFIES_NONE;
    }

    public static <T> Spec<T> convertClosureToSpec(Closure closure) {
        return new ClosureSpec(closure);
    }

    public static <T> Set<T> filterIterable(Iterable<? extends T> iterable, Spec<? super T> spec) {
        DeprecationLogger.nagUserOfReplacedMethod("Specs.filterIterable", "CollectionUtils.filter");
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T t : iterable) {
            if (!spec.isSatisfiedBy(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> AndSpec<T> and(Spec<? super T> ... specs) {
        return new AndSpec(specs);
    }

    public static <T> OrSpec<T> or(Spec<? super T> ... specs) {
        return new OrSpec(specs);
    }

    public static <T> NotSpec<T> not(Spec<? super T> spec) {
        return new NotSpec(spec);
    }

    public static <T> Spec<T> or(final boolean defaultWhenNoSpecs, List<? extends Spec<? super T>> specs) {
        if (specs.isEmpty()) {
            return new Spec<T>(){

                public boolean isSatisfiedBy(T element) {
                    return defaultWhenNoSpecs;
                }
            };
        }
        return new OrSpec(specs.toArray(new Spec[specs.size()]));
    }
}

