/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipUpToDateTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipUpToDateTaskExecuter.class);
    private final TaskExecuter executer;
    private final TaskArtifactStateRepository repository;

    public SkipUpToDateTaskExecuter(TaskExecuter executer, TaskArtifactStateRepository repository) {
        this.executer = executer;
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal task, TaskStateInternal state) {
        LOGGER.debug("Determining if {} is up-to-date", (Object)task);
        TaskArtifactState taskArtifactState = this.repository.getStateFor(task);
        try {
            if (taskArtifactState.isUpToDate()) {
                LOGGER.info("Skipping {} as it is up-to-date", (Object)task);
                state.upToDate();
                return;
            }
            LOGGER.debug("{} is not up-to-date", (Object)task);
            taskArtifactState.beforeTask();
            task.getOutputs().setHistory(taskArtifactState.getExecutionHistory());
            try {
                this.executer.execute(task, state);
                if (state.getFailure() == null) {
                    taskArtifactState.afterTask();
                }
            }
            finally {
                task.getOutputs().setHistory(null);
            }
        }
        finally {
            taskArtifactState.finished();
        }
    }
}

