/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class SkipOnlyIfTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(SkipOnlyIfTaskExecuter.class);
    private final TaskExecuter executer;

    public SkipOnlyIfTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    public void execute(TaskInternal task, TaskStateInternal state) {
        boolean skip;
        try {
            skip = !task.getOnlyIf().isSatisfiedBy((Object)task);
        }
        catch (Throwable t) {
            state.executed(new GradleException(String.format("Could not evaluate onlyIf predicate for %s.", task), t));
            return;
        }
        if (skip) {
            LOGGER.info("Skipping {} as task onlyIf is false.", task);
            state.skipped("SKIPPED");
            return;
        }
        this.executer.execute(task, state);
    }
}

