/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.internal.CachingDirectedGraphWalker;
import org.gradle.api.internal.DirectedGraph;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTaskDependencyResolveContext
implements TaskDependencyResolveContext,
TaskDependency {
    private final LinkedList<Object> queue = new LinkedList();
    private final CachingDirectedGraphWalker<Object, Task> walker = new CachingDirectedGraphWalker<Object, Task>(new TaskGraphImpl());
    private Task task;

    @Override
    public Set<? extends Task> getDependencies(Task task) {
        this.add(task.getTaskDependencies());
        return this.resolve(task);
    }

    @Override
    public Task getTask() {
        return this.task;
    }

    public Set<Task> resolve(Task task) {
        this.task = task;
        try {
            Set<Task> set = this.doResolve();
            return set;
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not determine the dependencies of %s.", task), (Throwable)e);
        }
        finally {
            this.queue.clear();
            this.task = null;
        }
    }

    private Set<Task> doResolve() {
        this.walker.add((Iterable<Object>)this.queue);
        return this.walker.findValues();
    }

    @Override
    public void add(Object dependency) {
        this.queue.add(dependency);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskGraphImpl
    implements DirectedGraph<Object, Task> {
        private TaskGraphImpl() {
        }

        @Override
        public void getNodeValues(Object node, Collection<Task> values, Collection<Object> connectedNodes) {
            if (node instanceof TaskDependencyInternal) {
                TaskDependencyInternal taskDependency = (TaskDependencyInternal)node;
                CachingTaskDependencyResolveContext.this.queue.clear();
                taskDependency.resolve(CachingTaskDependencyResolveContext.this);
                connectedNodes.addAll(CachingTaskDependencyResolveContext.this.queue);
            } else if (node instanceof Buildable) {
                Buildable buildable = (Buildable)node;
                connectedNodes.add(buildable.getBuildDependencies());
            } else if (node instanceof TaskDependency) {
                TaskDependency dependency = (TaskDependency)node;
                values.addAll(dependency.getDependencies(CachingTaskDependencyResolveContext.this.task));
            } else if (node instanceof Task) {
                values.add((Task)node);
            } else {
                throw new IllegalArgumentException(String.format("Cannot resolve object of unknown type %s to a Task.", node.getClass().getSimpleName()));
            }
        }
    }
}

