/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.PluginInstantiationException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginRegistry
implements PluginRegistry {
    private final Map<String, Class<? extends Plugin>> idMappings = new HashMap<String, Class<? extends Plugin>>();
    private final DefaultPluginRegistry parent;
    private final ClassLoader classLoader;
    private final Instantiator instantiator;

    public DefaultPluginRegistry(ClassLoader classLoader, Instantiator instantiator) {
        this(null, classLoader, instantiator);
    }

    private DefaultPluginRegistry(DefaultPluginRegistry parent, ClassLoader classLoader, Instantiator instantiator) {
        this.parent = parent;
        this.classLoader = classLoader;
        this.instantiator = instantiator;
    }

    @Override
    public PluginRegistry createChild(ClassLoader childClassPath, Instantiator instantiator) {
        return new DefaultPluginRegistry(this, childClassPath, instantiator);
    }

    @Override
    public <T extends Plugin> T loadPlugin(Class<T> pluginClass) {
        if (!Plugin.class.isAssignableFrom(pluginClass)) {
            throw new InvalidUserDataException(String.format("Cannot create plugin of type '%s' as it does not implement the Plugin interface.", pluginClass.getSimpleName()));
        }
        try {
            return (T)((Plugin)this.instantiator.newInstance(pluginClass, new Object[0]));
        }
        catch (ObjectInstantiationException e) {
            throw new PluginInstantiationException(String.format("Could not create plugin of type '%s'.", pluginClass.getSimpleName()), e.getCause());
        }
    }

    @Override
    public Class<? extends Plugin> getTypeForId(String pluginId) {
        Class<? extends Plugin> implClass;
        if (this.parent != null) {
            try {
                return this.parent.getTypeForId(pluginId);
            }
            catch (UnknownPluginException e) {
                // empty catch block
            }
        }
        if ((implClass = this.idMappings.get(pluginId)) != null) {
            return implClass;
        }
        URL resource = this.classLoader.getResource(String.format("META-INF/gradle-plugins/%s.properties", pluginId));
        if (resource == null) {
            throw new UnknownPluginException("Plugin with id '" + pluginId + "' not found.");
        }
        Properties properties = GUtil.loadProperties(resource);
        String implClassName = properties.getProperty("implementation-class");
        if (!GUtil.isTrue(implClassName)) {
            throw new PluginInstantiationException(String.format("No implementation class specified for plugin '%s' in %s.", pluginId, resource));
        }
        try {
            Class<?> rawClass = this.classLoader.loadClass(implClassName);
            if (!Plugin.class.isAssignableFrom(rawClass)) {
                throw new PluginInstantiationException(String.format("Implementation class '%s' specified for plugin '%s' does not implement the Plugin interface. Specified in %s.", implClassName, pluginId, resource));
            }
            implClass = rawClass.asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new PluginInstantiationException(String.format("Could not find implementation class '%s' for plugin '%s' specified in %s.", implClassName, pluginId, resource), e);
        }
        this.idMappings.put(pluginId, implClass);
        return implClass;
    }
}

