/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.api.internal.notations.api.UnsupportedNotationException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorHandlingNotationParser<T>
implements NotationParser<T> {
    private final String targetTypeDisplayName;
    private final String invalidNotationMessage;
    private final NotationParser<T> delegate;

    public ErrorHandlingNotationParser(String targetTypeDisplayName, String invalidNotationMessage, NotationParser<T> delegate) {
        this.targetTypeDisplayName = targetTypeDisplayName;
        this.invalidNotationMessage = invalidNotationMessage;
        this.delegate = delegate;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        this.delegate.describe(candidateFormats);
    }

    @Override
    public T parseNotation(Object notation) {
        try {
            return this.delegate.parseNotation(notation);
        }
        catch (UnsupportedNotationException e) {
            Object brokenNotation = e.getNotation();
            Formatter message = new Formatter();
            if (brokenNotation == null) {
                message.format("Cannot convert a null value to an object of type %s.%n", this.targetTypeDisplayName);
            } else {
                message.format("Cannot convert the provided notation to an object of type %s: %s.%n", this.targetTypeDisplayName, brokenNotation);
            }
            message.format("The following types/formats are supported:", new Object[0]);
            ArrayList<String> formats = new ArrayList<String>();
            this.describe(formats);
            for (String format : formats) {
                message.format("%n  - %s", format);
            }
            if (GUtil.isTrue(this.invalidNotationMessage)) {
                message.format("%n%s", this.invalidNotationMessage);
            }
            throw new InvalidUserDataException(message.toString());
        }
    }
}

