/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.filestore;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.copy.DeleteActionImpl;
import org.gradle.api.internal.filestore.AbstractFileStoreEntry;
import org.gradle.api.internal.filestore.FileStore;
import org.gradle.api.internal.filestore.FileStoreEntry;
import org.gradle.api.internal.filestore.FileStoreSearcher;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathKeyFileStore
implements FileStore<String>,
FileStoreSearcher<String> {
    public static final String IN_PROGRESS_MARKER_FILE_SUFFIX = ".fslck";
    private File baseDir;
    private final DeleteActionImpl deleteAction = new DeleteActionImpl(new IdentityFileResolver());

    public PathKeyFileStore(File baseDir) {
        this.baseDir = baseDir;
    }

    protected File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public FileStoreEntry move(String path, File source) {
        return this.saveIntoFileStore(source, this.getFile(path), true);
    }

    @Override
    public FileStoreEntry copy(String path, File source) {
        return this.saveIntoFileStore(source, this.getFile(path), false);
    }

    private File getFile(String path) {
        return new File(this.baseDir, path);
    }

    private File getFileWhileCleaningInProgress(String path) {
        File file = this.getFile(path);
        File markerFile = this.getInProgressMarkerFile(file);
        if (markerFile.exists()) {
            this.deleteAction.delete(file);
            this.deleteAction.delete(markerFile);
        }
        return file;
    }

    @Override
    public void moveFilestore(File destination) {
        if (this.baseDir.exists()) {
            GFileUtils.moveDirectory(this.baseDir, destination);
        }
        this.baseDir = destination;
    }

    @Override
    public FileStoreEntry add(String path, Action<File> addAction) {
        String error = String.format("Failed to add into filestore '%s' at '%s' ", this.getBaseDir().getAbsolutePath(), path);
        return this.doAdd(this.getFile(path), error, addAction);
    }

    protected FileStoreEntry saveIntoFileStore(final File source, final File destination, final boolean isMove) {
        String verb;
        String string = verb = isMove ? "move" : "copy";
        if (!source.exists()) {
            throw new GradleException(String.format("Cannot %s '%s' into filestore @ '%s' as it does not exist", verb, source, destination));
        }
        String error = String.format("Failed to %s file '%s' into filestore at '%s' ", verb, source, destination);
        return this.doAdd(destination, error, new Action<File>(){

            public void execute(File file) {
                if (isMove) {
                    GFileUtils.moveFile(source, destination);
                } else {
                    GFileUtils.copyFile(source, destination);
                }
            }
        });
    }

    protected FileStoreEntry doAdd(File destination, String failureDescription, Action<File> action) {
        try {
            GFileUtils.parentMkdirs(destination);
            File inProgressMarkerFile = this.getInProgressMarkerFile(destination);
            GFileUtils.touch(inProgressMarkerFile);
            try {
                this.deleteAction.delete(destination);
                action.execute((Object)destination);
            }
            catch (Throwable t) {
                try {
                    this.deleteAction.delete(destination);
                    throw t;
                }
                catch (Throwable throwable) {
                    this.deleteAction.delete(inProgressMarkerFile);
                    throw throwable;
                }
            }
            this.deleteAction.delete(inProgressMarkerFile);
        }
        catch (Throwable t) {
            throw new GradleException(failureDescription, t);
        }
        return this.entryAt(destination);
    }

    @Override
    public Set<? extends FileStoreEntry> search(String pattern) {
        if (!this.getBaseDir().exists()) {
            return Collections.emptySet();
        }
        final HashSet entries = new HashSet();
        this.findFiles(pattern).visit(new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                File file = fileDetails.getFile();
                if (!PathKeyFileStore.this.isInProgressMarkerFile(file) && !PathKeyFileStore.this.isInProgressFile(file)) {
                    entries.add(PathKeyFileStore.this.entryAt(file));
                }
            }
        });
        return entries;
    }

    private File getInProgressMarkerFile(File file) {
        return new File(file.getParent(), file.getName() + IN_PROGRESS_MARKER_FILE_SUFFIX);
    }

    private boolean isInProgressMarkerFile(File file) {
        return file.getName().endsWith(IN_PROGRESS_MARKER_FILE_SUFFIX);
    }

    private boolean isInProgressFile(File file) {
        return this.getInProgressMarkerFile(file).exists();
    }

    private DirectoryFileTree findFiles(String pattern) {
        DirectoryFileTree fileTree = new DirectoryFileTree(this.baseDir);
        PatternSet patternSet = new PatternSet();
        patternSet.include(pattern);
        return fileTree.filter(patternSet);
    }

    protected FileStoreEntry entryAt(File file) {
        return this.entryAt(GFileUtils.relativePath(this.baseDir, file));
    }

    protected FileStoreEntry entryAt(final String path) {
        return new AbstractFileStoreEntry(){

            public File getFile() {
                return new File(PathKeyFileStore.this.baseDir, path);
            }
        };
    }

    public FileStoreEntry get(String key) {
        File file = this.getFileWhileCleaningInProgress(key);
        if (file.exists()) {
            return this.entryAt(file);
        }
        return null;
    }
}

