/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.internal.UncheckedException;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathNotationParser<T extends String>
implements NotationParser<T> {
    @Override
    public void describe(Collection<String> candidateFormats) {
        candidateFormats.add("Strings, Boolean, Number like: 'path/to', true, Boolean.TRUE, 42, 3.14");
        candidateFormats.add("Closures, Callables");
    }

    @Override
    public T parseNotation(Object notation) {
        if (notation == null) {
            return null;
        }
        if (notation instanceof CharSequence || notation instanceof Number || notation instanceof Boolean) {
            return (T)notation.toString();
        }
        if (notation instanceof Closure) {
            Closure closure = (Closure)notation;
            Object called = closure.call();
            return (T)this.parseNotation(called);
        }
        if (notation instanceof Callable) {
            try {
                Callable callableNotation = (Callable)notation;
                Object called = callableNotation.call();
                return (T)this.parseNotation(called);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        DeprecationLogger.nagUserOfDeprecated(String.format("Converting class %s to path using toString() method", notation.getClass().getName()), "Please use java.io.File, java.lang.CharSequence, java.lang.Number, java.util.concurrent.Callable or groovy.lang.Closure");
        return (T)notation.toString();
    }
}

