/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import org.gradle.api.Action;
import org.gradle.api.internal.Actions;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.specs.Specs;
import org.gradle.listener.ActionBroadcast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionEventRegister<T> {
    private final ActionBroadcast<T> addActions;
    private final ActionBroadcast<T> removeActions;

    public CollectionEventRegister() {
        this(new ActionBroadcast(), new ActionBroadcast());
    }

    public CollectionEventRegister(ActionBroadcast<T> addActions, ActionBroadcast<T> removeActions) {
        this.addActions = addActions;
        this.removeActions = removeActions;
    }

    public Action<T> getAddAction() {
        return this.addActions;
    }

    public Action<T> getRemoveAction() {
        return this.removeActions;
    }

    public Action<? super T> registerAddAction(Action<? super T> addAction) {
        this.addActions.add(addAction);
        return addAction;
    }

    public Action<? super T> registerRemoveAction(Action<? super T> removeAction) {
        this.removeActions.add(removeAction);
        return removeAction;
    }

    public <S extends T> CollectionEventRegister<S> filtered(CollectionFilter<S> filter) {
        return new FilteringCollectionEventRegister<S>(filter, this.addActions, this.removeActions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteringCollectionEventRegister<S>
    extends CollectionEventRegister<S> {
        private final CollectionFilter<? super S> filter;

        public FilteringCollectionEventRegister(CollectionFilter<? super S> filter, ActionBroadcast<S> addActions, ActionBroadcast<S> removeActions) {
            super(addActions, removeActions);
            this.filter = filter;
        }

        @Override
        public Action<? super S> registerAddAction(Action<? super S> addAction) {
            return super.registerAddAction(Actions.filter(addAction, this.filter));
        }

        @Override
        public Action<? super S> registerRemoveAction(Action<? super S> removeAction) {
            return super.registerRemoveAction(Actions.filter(removeAction, this.filter));
        }

        @Override
        public <K extends S> CollectionEventRegister<K> filtered(CollectionFilter<K> filter) {
            return super.filtered(new CollectionFilter<K>(filter.getType(), Specs.and(filter, this.filter)));
        }
    }
}

