/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.CompositeUpToDateRule;
import org.gradle.api.internal.changedetection.FileSnapshotter;
import org.gradle.api.internal.changedetection.InputFilesChangedUpToDateRule;
import org.gradle.api.internal.changedetection.InputPropertiesChangedUpToDateRule;
import org.gradle.api.internal.changedetection.OutputFilesChangedUpToDateRule;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.TaskHistoryRepository;
import org.gradle.api.internal.changedetection.TaskTypeChangedUpToDateRule;
import org.gradle.api.internal.changedetection.UpToDateRule;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class DefaultTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private static final int MAX_OUT_OF_DATE_MESSAGES = 10;
    private static final Logger LOGGER = Logging.getLogger(DefaultTaskArtifactStateRepository.class);
    private final TaskHistoryRepository taskHistoryRepository;
    private final UpToDateRule upToDateRule;

    public DefaultTaskArtifactStateRepository(TaskHistoryRepository taskHistoryRepository, FileSnapshotter inputFilesSnapshotter, FileSnapshotter outputFilesSnapshotter) {
        this.taskHistoryRepository = taskHistoryRepository;
        this.upToDateRule = new CompositeUpToDateRule(new TaskTypeChangedUpToDateRule(), new InputPropertiesChangedUpToDateRule(), new OutputFilesChangedUpToDateRule(outputFilesSnapshotter), new InputFilesChangedUpToDateRule(inputFilesSnapshotter));
    }

    public TaskArtifactState getStateFor(TaskInternal task) {
        return new TaskArtifactStateImpl(task, this.taskHistoryRepository.getHistory(task));
    }

    private class TaskArtifactStateImpl
    implements TaskArtifactState,
    TaskExecutionHistory {
        private final TaskInternal task;
        private final TaskHistoryRepository.History history;
        private final TaskExecutionState execution;

        public TaskArtifactStateImpl(TaskInternal task, TaskHistoryRepository.History history) {
            this.task = task;
            this.history = history;
            this.execution = this.getExecution();
        }

        public boolean isUpToDate() {
            List<String> messages = this.execution.isUpToDate();
            if (messages == null || messages.isEmpty()) {
                LOGGER.info("Skipping {} as it is up-to-date.", this.task);
                return true;
            }
            if (LOGGER.isInfoEnabled()) {
                Formatter formatter = new Formatter();
                formatter.format("Executing %s due to:", this.task);
                for (int i = 0; i < messages.size() && i < 10; ++i) {
                    String message = messages.get(i);
                    formatter.format("%n%s", message);
                }
                if (messages.size() > 10) {
                    formatter.format("%n%d more ...", messages.size() - 10);
                }
                LOGGER.info(formatter.toString());
            }
            return false;
        }

        public FileCollection getOutputFiles() {
            return this.execution.getPreviousOutputFiles();
        }

        public TaskExecutionHistory getExecutionHistory() {
            return this;
        }

        public TaskExecutionState getExecution() {
            return new HistoricExecution(this.task, this.history, DefaultTaskArtifactStateRepository.this.upToDateRule);
        }

        public void afterTask() {
            if (this.execution.snapshot()) {
                this.history.update();
            }
        }

        public void beforeTask() {
        }

        public void finished() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HistoricExecution
    implements TaskExecutionState {
        private final TaskInternal task;
        private final TaskExecution lastExecution;
        private boolean upToDate;
        private final UpToDateRule rule;
        private TaskExecution thisExecution;
        private UpToDateRule.TaskUpToDateState upToDateState;

        public HistoricExecution(TaskInternal task, TaskHistoryRepository.History history, UpToDateRule rule) {
            this.task = task;
            this.lastExecution = history.getPreviousExecution();
            this.thisExecution = history.getCurrentExecution();
            this.rule = rule;
        }

        private void calcCurrentState() {
            if (this.upToDateState != null) {
                return;
            }
            this.upToDateState = this.rule.create(this.task, this.lastExecution, this.thisExecution);
        }

        @Override
        public FileCollection getPreviousOutputFiles() {
            return this.lastExecution != null && this.lastExecution.getOutputFilesSnapshot() != null ? this.lastExecution.getOutputFilesSnapshot().getFiles() : new SimpleFileCollection(new File[0]);
        }

        @Override
        public List<String> isUpToDate() {
            this.calcCurrentState();
            if (this.lastExecution == null) {
                return Collections.singletonList(String.format("No history is available for %s.", this.task));
            }
            ArrayList<String> messages = new ArrayList<String>();
            this.upToDateState.checkUpToDate(messages);
            if (messages.isEmpty()) {
                this.upToDate = true;
            }
            return messages;
        }

        @Override
        public boolean snapshot() {
            this.calcCurrentState();
            if (this.upToDate) {
                return false;
            }
            this.upToDateState.snapshotAfterTask();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface TaskExecutionState {
        public List<String> isUpToDate();

        public boolean snapshot();

        public FileCollection getPreviousOutputFiles();
    }
}

