/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.Actions;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.artifacts.DefaultArtifactRepositoryContainer;
import org.gradle.api.internal.artifacts.configurations.ResolverProvider;
import org.gradle.api.internal.artifacts.dsl.RepositoryFactoryInternal;
import org.gradle.api.internal.artifacts.repositories.FixedResolverArtifactRepository;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryHandler
extends DefaultArtifactRepositoryContainer
implements RepositoryHandler,
ResolverProvider {
    private final RepositoryFactoryInternal repositoryFactory;

    public DefaultRepositoryHandler(RepositoryFactoryInternal repositoryFactory, Instantiator instantiator) {
        super(repositoryFactory.getBaseRepositoryFactory(), instantiator);
        this.repositoryFactory = repositoryFactory;
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Action<? super FlatDirectoryArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.flatDir(action));
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Closure configureClosure) {
        return this.flatDir(new ClosureBackedAction(configureClosure));
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Map<String, ?> args) {
        return this.addRepository(this.repositoryFactory.flatDir(args));
    }

    @Override
    public MavenArtifactRepository mavenCentral() {
        return this.addRepository(this.repositoryFactory.mavenCentral());
    }

    @Override
    public MavenArtifactRepository mavenCentral(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("urls")) {
            DeprecationLogger.nagUserOfDeprecated("The 'urls' property of the RepositoryHandler.mavenCentral() method", "You should use the 'artifactUrls' property to define additional artifact locations");
            List urls = CollectionUtils.flattenToList((Object[])new Object[]{modifiedArgs.remove("urls")});
            modifiedArgs.put("artifactUrls", urls);
        }
        MavenArtifactRepository repo = this.repositoryFactory.mavenCentral();
        ConfigureUtil.configureByMap(modifiedArgs, repo);
        return this.addRepository(repo);
    }

    @Override
    public MavenArtifactRepository mavenLocal() {
        return this.addRepository(this.repositoryFactory.mavenLocal());
    }

    @Override
    public DependencyResolver mavenRepo(Map<String, ?> args) {
        return this.mavenRepo(args, null);
    }

    @Override
    public DependencyResolver mavenRepo(Map<String, ?> args, Closure configClosure) {
        List urls;
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("urls") && !(urls = CollectionUtils.flattenToList((Object[])new Object[]{modifiedArgs.remove("urls")})).isEmpty()) {
            DeprecationLogger.nagUserOfDeprecated("The 'urls' property of the RepositoryHandler.mavenRepo() method", "You should use the 'url' property to define the core maven repository & the 'artifactUrls' property to define any additional artifact locations");
            modifiedArgs.put("url", urls.get(0));
            List extraUrls = urls.subList(1, urls.size());
            modifiedArgs.put("artifactUrls", extraUrls);
        }
        MavenArtifactRepository repository = this.repositoryFactory.maven((Action<? super MavenArtifactRepository>)Actions.doNothing());
        ConfigureUtil.configureByMap(modifiedArgs, repository);
        DependencyResolver resolver = this.repositoryFactory.getBaseRepositoryFactory().toResolver(repository);
        ConfigureUtil.configure(configClosure, resolver);
        this.addRepository(new FixedResolverArtifactRepository(resolver));
        return resolver;
    }

    @Override
    public MavenArtifactRepository maven(Action<? super MavenArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.maven(action));
    }

    @Override
    public MavenArtifactRepository maven(Closure closure) {
        return this.maven(new ClosureBackedAction(closure));
    }

    @Override
    public IvyArtifactRepository ivy(Action<? super IvyArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.ivy(action));
    }

    @Override
    public IvyArtifactRepository ivy(Closure closure) {
        return this.ivy(new ClosureBackedAction(closure));
    }
}

