/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.dsl.RepositoryFactoryInternal;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryFactory
implements RepositoryFactoryInternal {
    public static final String FLAT_DIR_DEFAULT_NAME = "flatDir";
    private static final String MAVEN_REPO_DEFAULT_NAME = "maven";
    private static final String IVY_REPO_DEFAULT_NAME = "ivy";
    private final BaseRepositoryFactory baseRepositoryFactory;

    public DefaultRepositoryFactory(BaseRepositoryFactory baseRepositoryFactory) {
        this.baseRepositoryFactory = baseRepositoryFactory;
    }

    @Override
    public BaseRepositoryFactory getBaseRepositoryFactory() {
        return this.baseRepositoryFactory;
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Action<? super FlatDirectoryArtifactRepository> action) {
        return this.configure(this.getBaseRepositoryFactory().createFlatDirRepository(), action, FLAT_DIR_DEFAULT_NAME);
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("dirs")) {
            modifiedArgs.put("dirs", CollectionUtils.flattenToList((Object[])new Object[]{modifiedArgs.get("dirs")}));
        }
        return this.configure(this.getBaseRepositoryFactory().createFlatDirRepository(), modifiedArgs, FLAT_DIR_DEFAULT_NAME);
    }

    @Override
    public MavenArtifactRepository mavenLocal() {
        return this.configure(this.baseRepositoryFactory.createMavenLocalRepository(), "MavenLocal");
    }

    @Override
    public MavenArtifactRepository mavenCentral() {
        return this.configure(this.baseRepositoryFactory.createMavenCentralRepository(), "MavenRepo");
    }

    @Override
    public MavenArtifactRepository maven(Action<? super MavenArtifactRepository> action) {
        return this.configure(this.baseRepositoryFactory.createMavenRepository(), action, MAVEN_REPO_DEFAULT_NAME);
    }

    @Override
    public IvyArtifactRepository ivy(Action<? super IvyArtifactRepository> action) {
        return this.configure(this.baseRepositoryFactory.createIvyRepository(), action, IVY_REPO_DEFAULT_NAME);
    }

    private <T extends ArtifactRepository> T configure(T repository, Action<? super T> action, String name) {
        action.execute(repository);
        return this.configure(repository, name);
    }

    private <T extends ArtifactRepository> T configure(T repository, Map<String, ?> properties, String name) {
        ConfigureUtil.configureByMap(properties, repository);
        return this.configure(repository, name);
    }

    private <T extends ArtifactRepository> T configure(T repository, String name) {
        String repositoryName = repository.getName();
        if (!GUtil.isTrue(repositoryName)) {
            repository.setName(name);
        }
        return repository;
    }
}

