/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations.dynamicversion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.cache.ArtifactResolutionControl;
import org.gradle.api.artifacts.cache.DependencyResolutionControl;
import org.gradle.api.artifacts.cache.ModuleResolutionControl;
import org.gradle.api.artifacts.cache.ResolutionControl;
import org.gradle.api.artifacts.cache.ResolutionRules;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCachePolicy
implements CachePolicy,
ResolutionRules {
    private static final int SECONDS_IN_DAY = 86400;
    private final List<Action<? super DependencyResolutionControl>> dependencyCacheRules = new ArrayList<Action<? super DependencyResolutionControl>>();
    private final List<Action<? super ModuleResolutionControl>> moduleCacheRules = new ArrayList<Action<? super ModuleResolutionControl>>();
    private final List<Action<? super ArtifactResolutionControl>> artifactCacheRules = new ArrayList<Action<? super ArtifactResolutionControl>>();

    public DefaultCachePolicy() {
        this.cacheDynamicVersionsFor(86400, TimeUnit.SECONDS);
        this.cacheChangingModulesFor(86400, TimeUnit.SECONDS);
        this.cacheMissingModulesAndArtifactsFor(86400, TimeUnit.SECONDS);
    }

    @Override
    public void eachDependency(Action<? super DependencyResolutionControl> rule) {
        this.dependencyCacheRules.add(0, rule);
    }

    @Override
    public void eachModule(Action<? super ModuleResolutionControl> rule) {
        this.moduleCacheRules.add(0, rule);
    }

    @Override
    public void eachArtifact(Action<? super ArtifactResolutionControl> rule) {
        this.artifactCacheRules.add(0, rule);
    }

    public void cacheDynamicVersionsFor(final int value, final TimeUnit unit) {
        this.eachDependency((Action<? super DependencyResolutionControl>)new Action<DependencyResolutionControl>(){

            public void execute(DependencyResolutionControl dependencyResolutionControl) {
                dependencyResolutionControl.cacheFor(value, unit);
            }
        });
    }

    public void cacheChangingModulesFor(final int value, final TimeUnit units) {
        this.eachModule((Action<? super ModuleResolutionControl>)new Action<ModuleResolutionControl>(){

            public void execute(ModuleResolutionControl moduleResolutionControl) {
                if (moduleResolutionControl.isChanging()) {
                    moduleResolutionControl.cacheFor(value, units);
                }
            }
        });
    }

    private void cacheMissingModulesAndArtifactsFor(final int value, final TimeUnit units) {
        this.eachModule((Action<? super ModuleResolutionControl>)new Action<ModuleResolutionControl>(){

            public void execute(ModuleResolutionControl moduleResolutionControl) {
                if (moduleResolutionControl.getCachedResult() == null) {
                    moduleResolutionControl.cacheFor(value, units);
                }
            }
        });
        this.eachArtifact((Action<? super ArtifactResolutionControl>)new Action<ArtifactResolutionControl>(){

            public void execute(ArtifactResolutionControl artifactResolutionControl) {
                if (artifactResolutionControl.getCachedResult() == null) {
                    artifactResolutionControl.cacheFor(value, units);
                }
            }
        });
    }

    @Override
    public boolean mustRefreshDynamicVersion(ModuleVersionSelector selector, ModuleVersionIdentifier moduleId, long ageMillis) {
        CachedDependencyResolutionControl dependencyResolutionControl = new CachedDependencyResolutionControl(selector, moduleId, ageMillis);
        for (Action<? super DependencyResolutionControl> rule : this.dependencyCacheRules) {
            rule.execute((Object)dependencyResolutionControl);
            if (!dependencyResolutionControl.ruleMatch()) continue;
            return dependencyResolutionControl.mustCheck();
        }
        return false;
    }

    @Override
    public boolean mustRefreshModule(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion resolvedModuleVersion, ModuleRevisionId moduleRevisionId, long ageMillis) {
        return this.mustRefreshModule(moduleVersionId, resolvedModuleVersion, ageMillis, false);
    }

    @Override
    public boolean mustRefreshChangingModule(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion resolvedModuleVersion, long ageMillis) {
        return this.mustRefreshModule(moduleVersionId, resolvedModuleVersion, ageMillis, true);
    }

    private boolean mustRefreshModule(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion version, long ageMillis, boolean changingModule) {
        CachedModuleResolutionControl moduleResolutionControl = new CachedModuleResolutionControl(moduleVersionId, version, changingModule, ageMillis);
        for (Action<? super ModuleResolutionControl> rule : this.moduleCacheRules) {
            rule.execute((Object)moduleResolutionControl);
            if (!moduleResolutionControl.ruleMatch()) continue;
            return moduleResolutionControl.mustCheck();
        }
        return false;
    }

    @Override
    public boolean mustRefreshArtifact(ArtifactIdentifier artifactIdentifier, File cachedArtifactFile, long ageMillis) {
        CachedArtifactResolutionControl artifactResolutionControl = new CachedArtifactResolutionControl(artifactIdentifier, cachedArtifactFile, ageMillis);
        for (Action<? super ArtifactResolutionControl> rule : this.artifactCacheRules) {
            rule.execute((Object)artifactResolutionControl);
            if (!artifactResolutionControl.ruleMatch()) continue;
            return artifactResolutionControl.mustCheck();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedArtifactResolutionControl
    extends AbstractResolutionControl<ArtifactIdentifier, File>
    implements ArtifactResolutionControl {
        private CachedArtifactResolutionControl(ArtifactIdentifier artifactIdentifier, File cachedResult, long ageMillis) {
            super(artifactIdentifier, cachedResult, ageMillis);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedModuleResolutionControl
    extends AbstractResolutionControl<ModuleVersionIdentifier, ResolvedModuleVersion>
    implements ModuleResolutionControl {
        private final boolean changing;

        private CachedModuleResolutionControl(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion cachedVersion, boolean changing, long ageMillis) {
            super(moduleVersionId, cachedVersion, ageMillis);
            this.changing = changing;
        }

        @Override
        public boolean isChanging() {
            return this.changing;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedDependencyResolutionControl
    extends AbstractResolutionControl<ModuleVersionSelector, ModuleVersionIdentifier>
    implements DependencyResolutionControl {
        private CachedDependencyResolutionControl(ModuleVersionSelector request, ModuleVersionIdentifier cachedVersion, long ageMillis) {
            super(request, cachedVersion, ageMillis);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractResolutionControl<A, B>
    implements ResolutionControl<A, B> {
        private final A request;
        private final B cachedResult;
        private final long ageMillis;
        private boolean ruleMatch;
        private boolean mustCheck;

        private AbstractResolutionControl(A request, B cachedResult, long ageMillis) {
            this.request = request;
            this.cachedResult = cachedResult;
            this.ageMillis = ageMillis;
        }

        @Override
        public A getRequest() {
            return this.request;
        }

        @Override
        public B getCachedResult() {
            return this.cachedResult;
        }

        @Override
        public void cacheFor(int value, TimeUnit units) {
            long timeoutMillis = TimeUnit.MILLISECONDS.convert(value, units);
            if (this.ageMillis <= timeoutMillis) {
                this.setMustCheck(false);
            } else {
                this.setMustCheck(true);
            }
        }

        @Override
        public void useCachedResult() {
            this.setMustCheck(false);
        }

        @Override
        public void refresh() {
            this.setMustCheck(true);
        }

        private void setMustCheck(boolean val) {
            this.ruleMatch = true;
            this.mustCheck = val;
        }

        public boolean ruleMatch() {
            return this.ruleMatch;
        }

        public boolean mustCheck() {
            return this.mustCheck;
        }
    }
}

