/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;

public class ResolvedConfigurationIdentifier {
    private final ModuleVersionIdentifier id;
    private final String configuration;

    public ResolvedConfigurationIdentifier(String moduleGroup, String moduleName, String moduleVersion, String configuration) {
        this.id = new DefaultModuleVersionIdentifier(moduleGroup, moduleName, moduleVersion);
        this.configuration = configuration;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getModuleGroup() {
        return this.id.getGroup();
    }

    public String getModuleName() {
        return this.id.getName();
    }

    public String getModuleVersion() {
        return this.id.getVersion();
    }

    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", this.getModuleGroup(), this.getModuleVersion(), this.getModuleName(), this.configuration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedConfigurationIdentifier that = (ResolvedConfigurationIdentifier)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.configuration.equals(that.configuration);
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.configuration.hashCode();
    }
}

