/*
 * Copyright 2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.publish.ivy.internal;

import org.gradle.api.internal.artifacts.ArtifactPublisher;

public class IvyPublisher {

    private final ArtifactPublisher artifactPublisher;

    public IvyPublisher(ArtifactPublisher artifactPublisher) {
        this.artifactPublisher = artifactPublisher;
    }

    public void publish(IvyNormalizedPublication publication) {
        artifactPublisher.publish(publication.getModule(), publication.getConfigurations(), publication.getDescriptorFile(), publication.getDescriptorTransformer());
    }

}
