/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import org.gradle.api.Action;
import org.gradle.util.LineBufferingOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinePerThreadBufferingOutputStream
extends PrintStream {
    private final Action<String> listener;
    private final boolean includeEol;
    private final ThreadLocal<PrintStream> stream = new ThreadLocal<PrintStream>(){

        @Override
        protected PrintStream initialValue() {
            return AccessController.doPrivileged(new PrivilegedAction<PrintStream>(){

                @Override
                public PrintStream run() {
                    return new PrintStream(new LineBufferingOutputStream((Action<String>)LinePerThreadBufferingOutputStream.this.listener, LinePerThreadBufferingOutputStream.this.includeEol));
                }
            });
        }
    };

    public LinePerThreadBufferingOutputStream(Action<String> listener) {
        this(listener, false);
    }

    public LinePerThreadBufferingOutputStream(Action<String> listener, boolean includeEol) {
        super(new ByteArrayOutputStream(), true);
        this.listener = listener;
        this.includeEol = includeEol;
    }

    private PrintStream getStream() {
        return this.stream.get();
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.getStream().append(csq);
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.getStream().append(c);
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        this.getStream().append(csq, start, end);
        return this;
    }

    @Override
    public boolean checkError() {
        return this.getStream().checkError();
    }

    @Override
    public void close() {
        this.getStream().close();
    }

    @Override
    public void flush() {
        this.getStream().flush();
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        this.getStream().format(format, args);
        return this;
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        this.getStream().format(l, format, args);
        return this;
    }

    @Override
    public void print(boolean b) {
        this.getStream().print(b);
    }

    @Override
    public void print(char c) {
        this.getStream().print(c);
    }

    @Override
    public void print(double d) {
        this.getStream().print(d);
    }

    @Override
    public void print(float f) {
        this.getStream().print(f);
    }

    @Override
    public void print(int i) {
        this.getStream().print(i);
    }

    @Override
    public void print(long l) {
        this.getStream().print(l);
    }

    @Override
    public void print(Object obj) {
        this.getStream().print(obj);
    }

    @Override
    public void print(char[] s) {
        this.getStream().print(s);
    }

    @Override
    public void print(String s) {
        this.getStream().print(s);
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        this.getStream().printf(format, args);
        return this;
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        this.getStream().printf(l, format, args);
        return this;
    }

    @Override
    public void println() {
        this.getStream().println();
    }

    @Override
    public void println(boolean x) {
        this.getStream().println(x);
    }

    @Override
    public void println(char x) {
        this.getStream().println(x);
    }

    @Override
    public void println(char[] x) {
        this.getStream().println(x);
    }

    @Override
    public void println(double x) {
        this.getStream().println(x);
    }

    @Override
    public void println(float x) {
        this.getStream().println(x);
    }

    @Override
    public void println(int x) {
        this.getStream().println(x);
    }

    @Override
    public void println(long x) {
        this.getStream().println(x);
    }

    @Override
    public void println(Object x) {
        this.getStream().println(x);
    }

    @Override
    public void println(String x) {
        this.getStream().println(x);
    }

    @Override
    public void write(int b) {
        this.getStream().write(b);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.getStream().write(buf, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getStream().write(b);
    }
}

