/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectUtil;
import org.gradle.util.Configurable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureUtil {
    public static <T> T configureByMap(Map<?, ?> properties, T delegate) {
        DynamicObject dynamicObject = DynamicObjectUtil.asDynamicObject(delegate);
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            String name = entry.getKey().toString();
            Object value = entry.getValue();
            if (dynamicObject.hasProperty(name)) {
                dynamicObject.setProperty(name, value);
                continue;
            }
            try {
                dynamicObject.invokeMethod(name, value);
            }
            catch (MissingMethodException e) {
                dynamicObject.setProperty(name, value);
            }
        }
        return delegate;
    }

    public static <T> T configureByMap(Map<String, ?> properties, T delegate, Collection<String> mandatoryKeys) {
        Collection missingKeys = CollectionUtils.subtract(mandatoryKeys, properties.keySet());
        if (!missingKeys.isEmpty()) {
            throw new IncompleteInputException("Input configuration map does not contain following mandatory keys: " + missingKeys, missingKeys);
        }
        return ConfigureUtil.configureByMap(properties, delegate);
    }

    public static <T> T configure(Closure configureClosure, T delegate) {
        return ConfigureUtil.configure(configureClosure, delegate, 1, true);
    }

    public static <T> T configure(Closure configureClosure, T delegate, boolean configureableAware) {
        return ConfigureUtil.configure(configureClosure, delegate, 1, configureableAware);
    }

    public static <T> T configure(Closure configureClosure, T delegate, int resolveStrategy) {
        return ConfigureUtil.configure(configureClosure, delegate, resolveStrategy, false);
    }

    private static <T> T configure(Closure configureClosure, T delegate, int resolveStrategy, boolean configureableAware) {
        if (configureClosure == null) {
            return delegate;
        }
        if (configureableAware && delegate instanceof Configurable) {
            ((Configurable)delegate).configure(configureClosure);
        } else {
            Closure copy = (Closure)configureClosure.clone();
            copy.setResolveStrategy(resolveStrategy);
            copy.setDelegate(delegate);
            if (copy.getMaximumNumberOfParameters() == 0) {
                copy.call();
            } else {
                copy.call(delegate);
            }
        }
        return delegate;
    }

    public static class IncompleteInputException
    extends RuntimeException {
        private final Collection missingKeys;

        public IncompleteInputException(String message, Collection missingKeys) {
            super(message);
            this.missingKeys = missingKeys;
        }

        public Collection getMissingKeys() {
            return this.missingKeys;
        }
    }
}

