/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.util.ToStringTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionUtils {
    public static <T> T findFirst(Iterable<T> source, Spec<? super T> filter) {
        for (T item : source) {
            if (!filter.isSatisfiedBy(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> Set<T> filter(Set<T> set, Spec<? super T> filter) {
        return CollectionUtils.filter(set, new LinkedHashSet(), filter);
    }

    public static <T> List<T> filter(List<T> list, Spec<? super T> filter) {
        return CollectionUtils.filter(list, new LinkedList(), filter);
    }

    public static <T, C extends Collection<T>> C filter(Iterable<T> source, C destination, Spec<? super T> filter) {
        for (T item : source) {
            if (!filter.isSatisfiedBy(item)) continue;
            destination.add(item);
        }
        return destination;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Spec<Map.Entry<K, V>> filter) {
        return CollectionUtils.filter(map, new HashMap(), filter);
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Map<K, V> destination, Spec<Map.Entry<K, V>> filter) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.isSatisfiedBy(entry)) continue;
            destination.put(entry.getKey(), entry.getValue());
        }
        return destination;
    }

    public static <R, I> List<R> collect(List<? extends I> list, Transformer<R, I> transformer) {
        return CollectionUtils.collect(list, new ArrayList(list.size()), transformer);
    }

    public static <R, I> Set<R> collect(Set<? extends I> set, Transformer<R, I> transformer) {
        return CollectionUtils.collect(set, new HashSet(), transformer);
    }

    public static <R, I, C extends Collection<R>> C collect(Iterable<? extends I> source, C destination, Transformer<R, I> transformer) {
        for (I item : source) {
            destination.add(transformer.transform(item));
        }
        return destination;
    }

    public static List<String> toStringList(Iterable<?> iterable) {
        ArrayList result = Lists.newArrayList();
        for (Object elem : iterable) {
            result.add(elem.toString());
        }
        return result;
    }

    public static <E> List<E> compact(List<E> list) {
        boolean foundAtLeastOneNull = false;
        List<E> compacted = null;
        int i = 0;
        for (E element : list) {
            if (element == null) {
                if (!foundAtLeastOneNull) {
                    compacted = new ArrayList(list.size());
                    if (i > 0) {
                        compacted.addAll(list.subList(0, i));
                    }
                }
                foundAtLeastOneNull = true;
            } else if (foundAtLeastOneNull) {
                compacted.add(element);
            }
            ++i;
        }
        return foundAtLeastOneNull ? compacted : list;
    }

    public static <C extends Collection<String>> C stringize(Iterable<?> source, C destination) {
        return CollectionUtils.collect(source, destination, new ToStringTransformer());
    }

    public static List<String> stringize(List<?> source) {
        return CollectionUtils.stringize(source, new ArrayList(source.size()));
    }

    public static <E> boolean replace(List<E> list, Spec<? super E> filter, Transformer<E, ? super E> transformer) {
        boolean replaced = false;
        int i = 0;
        for (E it : list) {
            if (filter.isSatisfiedBy(it)) {
                list.set(i, transformer.transform(it));
                replaced = true;
            }
            ++i;
        }
        return replaced;
    }

    public static <K, V> void collectMap(Map<K, V> destination, Iterable<? extends V> items, Transformer<? extends K, ? super V> keyGenerator) {
        for (V item : items) {
            destination.put(keyGenerator.transform(item), item);
        }
    }

    public static <K, V> Map<K, V> collectMap(Iterable<? extends V> items, Transformer<? extends K, ? super V> keyGenerator) {
        LinkedHashMap map = new LinkedHashMap();
        CollectionUtils.collectMap(map, items, keyGenerator);
        return map;
    }

    public static <T> boolean every(Iterable<T> things, Spec<? super T> predicate) {
        for (T thing : things) {
            if (predicate.isSatisfiedBy(thing)) continue;
            return false;
        }
        return true;
    }

    public static <T> SetDiff<T> diffSetsBy(Set<? extends T> left, Set<? extends T> right, Transformer<?, T> compareBy) {
        if (left == null) {
            throw new NullPointerException("'left' set is null");
        }
        if (right == null) {
            throw new NullPointerException("'right' set is null");
        }
        SetDiff setDiff = new SetDiff();
        Map<?, T> indexedLeft = CollectionUtils.collectMap(left, compareBy);
        Map<?, T> indexedRight = CollectionUtils.collectMap(right, compareBy);
        for (Map.Entry<?, T> leftEntry : indexedLeft.entrySet()) {
            T rightValue = indexedRight.remove(leftEntry.getKey());
            if (rightValue == null) {
                setDiff.leftOnly.add(leftEntry.getValue());
                continue;
            }
            SetDiff.Pair pair = new SetDiff.Pair();
            pair.left = leftEntry.getValue();
            pair.right = rightValue;
            setDiff.common.add(pair);
        }
        for (Map.Entry<?, ? extends T> rightValue : indexedRight.values()) {
            setDiff.rightOnly.add(rightValue);
        }
        return setDiff;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDiff<T> {
        public Set<T> leftOnly = new HashSet<T>();
        public Set<Pair<T>> common = new HashSet<Pair<T>>();
        public Set<T> rightOnly = new HashSet<T>();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Pair<T> {
            public T left;
            public T right;
        }
    }
}

