/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.io.File;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.reporting.DomReportRenderer;
import org.gradle.reporting.TextReportRenderer;
import org.gradle.util.GFileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlReportRenderer {
    private DocumentBuilder documentBuilder;
    private Transformer transformer;
    private final Set<URL> resources = new HashSet<URL>();

    public void requireResource(URL resource) {
        this.resources.add(resource);
    }

    public <T> TextReportRenderer<T> renderer(final DomReportRenderer<T> renderer) {
        return this.renderer(new TextReportRenderer<T>(){

            @Override
            protected void writeTo(T model, Writer writer) throws Exception {
                if (HtmlReportRenderer.this.documentBuilder == null) {
                    HtmlReportRenderer.this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                }
                Document document = HtmlReportRenderer.this.documentBuilder.newDocument();
                Element html = document.createElement("html");
                document.appendChild(html);
                renderer.render(model, html);
                if (HtmlReportRenderer.this.transformer == null) {
                    TransformerFactory factory = TransformerFactory.newInstance();
                    HtmlReportRenderer.this.transformer = factory.newTransformer();
                    HtmlReportRenderer.this.transformer.setOutputProperty("indent", "yes");
                    HtmlReportRenderer.this.transformer.setOutputProperty("method", "html");
                    HtmlReportRenderer.this.transformer.setOutputProperty("media-type", "text/html");
                }
                writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
                writer.write(SystemProperties.getLineSeparator());
                HtmlReportRenderer.this.transformer.transform(new DOMSource(document), new StreamResult(writer));
            }
        });
    }

    public <T> TextReportRenderer<T> renderer(final TextReportRenderer<T> renderer) {
        return new TextReportRenderer<T>(){

            @Override
            protected void writeTo(T model, Writer out) throws Exception {
                renderer.writeTo(model, out);
            }

            @Override
            public void writeTo(T model, File file) {
                super.writeTo(model, file);
                for (URL resource : HtmlReportRenderer.this.resources) {
                    String name = StringUtils.substringAfterLast((String)resource.getPath(), (String)"/");
                    File destFile = new File(file.getParentFile(), name);
                    if (destFile.exists()) continue;
                    GFileUtils.copyURLToFile(resource, destFile);
                }
            }
        };
    }
}

