/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Synchronizer;
import org.gradle.internal.nativeplatform.jna.WindowsHandlesManipulator;
import org.gradle.internal.os.OperatingSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessParentingInitializer {
    private static boolean initialized;
    private static Synchronizer synchronizer;
    private static final Logger LOGGER;

    public static void intitialize() {
        ProcessParentingInitializer.intitialize(new Factory<Object>(){

            public Object create() {
                return null;
            }
        });
    }

    public static <T> T intitialize(final Factory<T> operation) {
        if (initialized) {
            return (T)operation.create();
        }
        return (T)synchronizer.synchronize(new Factory<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T create() {
                if (initialized) {
                    return operation.create();
                }
                try {
                    if (OperatingSystem.current().isWindows()) {
                        new WindowsHandlesManipulator().uninheritStandardStreams();
                    }
                    Object object = operation.create();
                    return object;
                }
                finally {
                    initialized = true;
                    LOGGER.info("An attempt to initialize for well behaving parent process finished.");
                }
            }
        });
    }

    static {
        synchronizer = new Synchronizer();
        LOGGER = Logging.getLogger(ProcessParentingInitializer.class);
    }
}

