/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.TimeProvider;
import org.gradle.logging.internal.LogLevelChangeEvent;
import org.gradle.logging.internal.LoggingSystem;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.StyledTextOutputEvent;
import org.gradle.util.LinePerThreadBufferingOutputStream;

abstract class PrintStreamLoggingSystem
implements LoggingSystem {
    private final AtomicReference<StandardOutputListener> destination = new AtomicReference();
    private final PrintStream outstr = new LinePerThreadBufferingOutputStream(new Action<String>(){

        public void execute(String output) {
            ((StandardOutputListener)PrintStreamLoggingSystem.this.destination.get()).onOutput(output);
        }
    }, true);
    private StandardOutputListener original;
    private LogLevel logLevel;
    private final StandardOutputListener listener;
    private final OutputEventListener outputEventListener;

    protected PrintStreamLoggingSystem(OutputEventListener listener, String category, TimeProvider timeProvider) {
        this.outputEventListener = listener;
        this.listener = new OutputEventDestination(listener, category, timeProvider);
    }

    protected abstract PrintStream get();

    protected abstract void set(PrintStream var1);

    public LoggingSystem.Snapshot snapshot() {
        return new SnapshotImpl(this.logLevel);
    }

    public void restore(LoggingSystem.Snapshot state) {
        SnapshotImpl snapshot = (SnapshotImpl)state;
        this.install();
        if (snapshot.logLevel == null) {
            this.destination.set(this.original);
        } else {
            this.logLevel = snapshot.logLevel;
            this.outputEventListener.onOutput(new LogLevelChangeEvent(snapshot.logLevel));
            this.destination.set(this.listener);
        }
    }

    public LoggingSystem.Snapshot on(LogLevel level) {
        LoggingSystem.Snapshot snapshot = this.snapshot();
        this.install();
        this.logLevel = level;
        this.outputEventListener.onOutput(new LogLevelChangeEvent(this.logLevel));
        this.destination.set(this.listener);
        return snapshot;
    }

    public LoggingSystem.Snapshot off() {
        LoggingSystem.Snapshot snapshot = this.snapshot();
        if (this.original != null) {
            this.outstr.flush();
            this.destination.set(this.original);
            this.logLevel = null;
        }
        return snapshot;
    }

    private void install() {
        if (this.original == null) {
            PrintStream originalStream = this.get();
            this.original = new PrintStreamDestination(originalStream);
        }
        this.outstr.flush();
        if (this.get() != this.outstr) {
            this.set(this.outstr);
        }
    }

    private static class OutputEventDestination
    implements StandardOutputListener {
        private final OutputEventListener listener;
        private final String category;
        private final TimeProvider timeProvider;

        public OutputEventDestination(OutputEventListener listener, String category, TimeProvider timeProvider) {
            this.listener = listener;
            this.category = category;
            this.timeProvider = timeProvider;
        }

        public void onOutput(CharSequence output) {
            this.listener.onOutput(new StyledTextOutputEvent(this.timeProvider.getCurrentTime(), this.category, output.toString()));
        }
    }

    private static class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final LogLevel logLevel;

        public SnapshotImpl(LogLevel logLevel) {
            this.logLevel = logLevel;
        }
    }

    private static class PrintStreamDestination
    implements StandardOutputListener {
        private final PrintStream originalStream;

        public PrintStreamDestination(PrintStream originalStream) {
            this.originalStream = originalStream;
        }

        public void onOutput(CharSequence output) {
            this.originalStream.print(output);
        }
    }
}

