/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.FileDescriptor;
import java.io.PrintStream;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.nativeplatform.TerminalDetector;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.logging.internal.AnsiConsole;
import org.gradle.logging.internal.Console;
import org.gradle.logging.internal.ConsoleBackedProgressRenderer;
import org.gradle.logging.internal.DefaultColorMap;
import org.gradle.logging.internal.LogLevelChangeEvent;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.LoggingOutputInternal;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressLogEventGenerator;
import org.gradle.logging.internal.StreamBackedStandardOutputListener;
import org.gradle.logging.internal.StreamingStyledTextOutput;
import org.gradle.logging.internal.StyledTextOutputBackedRenderer;

public class OutputEventRenderer
implements OutputEventListener,
LoggingConfigurer,
LoggingOutputInternal {
    private final ListenerBroadcast<OutputEventListener> formatters = new ListenerBroadcast<OutputEventListener>(OutputEventListener.class);
    private final ListenerBroadcast<StandardOutputListener> stdoutListeners = new ListenerBroadcast<StandardOutputListener>(StandardOutputListener.class);
    private final ListenerBroadcast<StandardOutputListener> stderrListeners = new ListenerBroadcast<StandardOutputListener>(StandardOutputListener.class);
    private final TerminalDetector terminalDetector;
    private final Object lock = new Object();
    private final DefaultColorMap colourMap = new DefaultColorMap();
    private LogLevel logLevel = LogLevel.LIFECYCLE;

    public OutputEventRenderer(TerminalDetector terminalDetector) {
        OutputEventListener stdOutChain = this.onNonError(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(this.stdoutListeners.getSource())), false));
        this.formatters.add(stdOutChain);
        OutputEventListener stdErrChain = this.onError(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(this.stderrListeners.getSource())), false));
        this.formatters.add(stdErrChain);
        this.terminalDetector = terminalDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void colorStdOutAndStdErr(boolean colorOutput) {
        Object object = this.lock;
        synchronized (object) {
            this.colourMap.setUseColor(colorOutput);
        }
    }

    public OutputEventRenderer addStandardOutputAndError() {
        boolean stdOutIsTerminal = this.terminalDetector.isTerminal(FileDescriptor.out);
        boolean stdErrIsTerminal = this.terminalDetector.isTerminal(FileDescriptor.err);
        if (stdOutIsTerminal) {
            PrintStream outStr = org.fusesource.jansi.AnsiConsole.out();
            AnsiConsole console = new AnsiConsole(outStr, outStr, this.colourMap);
            this.addConsole(console, true, stdErrIsTerminal);
        } else if (stdErrIsTerminal) {
            PrintStream errStr = org.fusesource.jansi.AnsiConsole.err();
            AnsiConsole console = new AnsiConsole(errStr, errStr, this.colourMap);
            this.addConsole(console, false, true);
        }
        if (!stdOutIsTerminal) {
            this.addStandardOutput(System.out);
        }
        if (!stdErrIsTerminal) {
            this.addStandardError(System.err);
        }
        return this;
    }

    public OutputEventRenderer addStandardOutput(Appendable out) {
        this.addStandardOutputListener(new StreamBackedStandardOutputListener(out));
        return this;
    }

    public OutputEventRenderer addStandardError(Appendable err) {
        this.addStandardErrorListener(new StreamBackedStandardOutputListener(err));
        return this;
    }

    public void addOutputEventListener(OutputEventListener listener) {
        this.formatters.add(listener);
    }

    public void removeOutputEventListener(OutputEventListener listener) {
        this.formatters.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputEventRenderer addConsole(Console console, boolean stdout, boolean stderr) {
        ConsoleBackedProgressRenderer consoleChain = new ConsoleBackedProgressRenderer(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(console.getMainArea()), true), console);
        Object object = this.lock;
        synchronized (object) {
            if (stdout && stderr) {
                this.formatters.add(consoleChain);
            } else if (stdout) {
                this.formatters.add(this.onNonError(consoleChain));
            } else {
                this.formatters.add(this.onError(consoleChain));
            }
        }
        return this;
    }

    private OutputEventListener onError(final OutputEventListener listener) {
        return new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                if (event.getLogLevel() == LogLevel.ERROR || event.getLogLevel() == null) {
                    listener.onOutput(event);
                }
            }
        };
    }

    private OutputEventListener onNonError(final OutputEventListener listener) {
        return new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                if (event.getLogLevel() != LogLevel.ERROR || event.getLogLevel() == null) {
                    listener.onOutput(event);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.remove(listener);
        }
    }

    public void configure(LogLevel logLevel) {
        this.onOutput(new LogLevelChangeEvent(logLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutput(OutputEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (event.getLogLevel() != null && event.getLogLevel().compareTo(this.logLevel) < 0) {
                return;
            }
            if (event instanceof LogLevelChangeEvent) {
                LogLevelChangeEvent changeEvent = (LogLevelChangeEvent)event;
                LogLevel newLogLevel = changeEvent.getNewLogLevel();
                if (newLogLevel == this.logLevel) {
                    return;
                }
                this.logLevel = newLogLevel;
            }
            this.formatters.getSource().onOutput(event);
        }
    }
}

