/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.TimeProvider;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.AbstractStyledTextOutput;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.StyledTextOutputEvent;
import org.gradle.util.LineBufferingOutputStream;

public class LoggingBackedStyledTextOutput
extends AbstractStyledTextOutput {
    private final LineBufferingOutputStream outstr;
    private StyledTextOutput.Style style = StyledTextOutput.Style.Normal;
    private boolean styleChange;

    public LoggingBackedStyledTextOutput(OutputEventListener listener, String category, LogLevel logLevel, TimeProvider timeProvider) {
        this.outstr = new LineBufferingOutputStream(new LogAction(listener, category, logLevel, timeProvider), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStyleChange(StyledTextOutput.Style style) {
        this.styleChange = true;
        try {
            this.outstr.flush();
        }
        finally {
            this.styleChange = false;
        }
        this.style = style;
    }

    protected void doAppend(String text) {
        try {
            this.outstr.write(text.getBytes());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogAction
    implements Action<String> {
        private final OutputEventListener listener;
        private final String category;
        private final LogLevel logLevel;
        private final TimeProvider timeProvider;
        private List<StyledTextOutputEvent.Span> spans;

        public LogAction(OutputEventListener listener, String category, LogLevel logLevel, TimeProvider timeProvider) {
            this.listener = listener;
            this.category = category;
            this.logLevel = logLevel;
            this.timeProvider = timeProvider;
        }

        public void execute(String text) {
            if (text.length() == 0) {
                return;
            }
            StyledTextOutputEvent.Span span = new StyledTextOutputEvent.Span(LoggingBackedStyledTextOutput.this.style, text);
            if (LoggingBackedStyledTextOutput.this.styleChange) {
                if (this.spans == null) {
                    this.spans = new ArrayList<StyledTextOutputEvent.Span>();
                }
                this.spans.add(span);
                return;
            }
            if (this.spans != null) {
                this.spans.add(span);
            } else {
                this.spans = Collections.singletonList(span);
            }
            StyledTextOutputEvent event = new StyledTextOutputEvent(this.timeProvider.getCurrentTime(), this.category, this.logLevel, this.spans);
            this.spans = null;
            this.listener.onOutput(event);
        }
    }
}

