/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

public class DependencyResolutionLogger
implements DependencyResolutionListener {
    private final ProgressLoggerFactory loggerFactory;
    private final ThreadLocal<ProgressLogger> progressLogger = new ThreadLocal();

    public DependencyResolutionLogger(ProgressLoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
    }

    public void beforeResolve(ResolvableDependencies dependencies) {
        this.checkLogger(false);
        ProgressLogger logger = this.loggerFactory.newOperation(DependencyResolutionLogger.class);
        logger.setDescription(String.format("Resolve %s", dependencies));
        logger.setShortDescription(String.format("Resolving %s", dependencies));
        logger.started();
        this.progressLogger.set(logger);
    }

    public void afterResolve(ResolvableDependencies dependencies) {
        this.checkLogger(true);
        this.progressLogger.get().completed();
        this.progressLogger.remove();
    }

    private void checkLogger(boolean shouldExist) {
        ProgressLogger logger = this.progressLogger.get();
        if (shouldExist && logger == null) {
            throw new IllegalStateException("Logging operation not started");
        }
        if (!shouldExist && logger != null) {
            throw new IllegalStateException("Logging operation already in progress");
        }
    }
}

