/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Set;
import org.gradle.BuildAdapter;
import org.gradle.GradleLauncher;
import org.gradle.StartParameter;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.plugins.EmbeddableJavaProject;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.util.WrapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSourceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSourceBuilder.class);
    private final GradleLauncherFactory gradleLauncherFactory;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final CacheRepository cacheRepository;
    private static final String DEFAULT_BUILD_SOURCE_SCRIPT_RESOURCE = "defaultBuildSourceScript.txt";

    public BuildSourceBuilder(GradleLauncherFactory gradleLauncherFactory, ClassLoaderRegistry classLoaderRegistry, CacheRepository cacheRepository) {
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.classLoaderRegistry = classLoaderRegistry;
        this.cacheRepository = cacheRepository;
    }

    public URLClassLoader buildAndCreateClassLoader(StartParameter startParameter) {
        ClassPath classpath = this.createBuildSourceClasspath(startParameter);
        return new URLClassLoader(classpath.getAsURLArray(), this.classLoaderRegistry.getRootClassLoader());
    }

    private ClassPath createBuildSourceClasspath(StartParameter startParameter) {
        assert (startParameter.getCurrentDir() != null && startParameter.getBuildFile() == null);
        LOGGER.debug("Starting to build the build sources.");
        if (!startParameter.getCurrentDir().isDirectory()) {
            LOGGER.debug("Gradle source dir does not exist. We leave.");
            return new DefaultClassPath(new File[0]);
        }
        LOGGER.info("================================================ Start building buildSrc");
        PersistentCache buildSrcCache = (PersistentCache)this.cacheRepository.cache("buildSrc").withLockMode(FileLockManager.LockMode.None).forObject(startParameter.getCurrentDir()).withVersionStrategy(CacheBuilder.VersionStrategy.SharedCacheInvalidateOnVersionChange).open();
        GradleLauncher gradleLauncher = this.buildGradleLauncher(startParameter);
        return (ClassPath)buildSrcCache.useCache("rebuild buildSrc", new BuildSrcUpdateFactory(buildSrcCache, gradleLauncher));
    }

    private GradleLauncher buildGradleLauncher(StartParameter startParameter) {
        StartParameter startParameterArg = startParameter.newInstance();
        startParameterArg.setProjectProperties(startParameter.getProjectProperties());
        startParameterArg.setSearchUpwards(false);
        startParameterArg.setProfile(startParameter.isProfile());
        return this.gradleLauncherFactory.newInstance(startParameterArg);
    }

    static URL getDefaultScript() {
        return BuildSourceBuilder.class.getResource(DEFAULT_BUILD_SOURCE_SCRIPT_RESOURCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildSrcUpdateFactory
    implements Factory<DefaultClassPath> {
        private final PersistentCache cache;
        private final GradleLauncher gradleLauncher;

        public BuildSrcUpdateFactory(PersistentCache cache, GradleLauncher gradleLauncher) {
            this.cache = cache;
            this.gradleLauncher = gradleLauncher;
        }

        public DefaultClassPath create() {
            File markerFile = new File(this.cache.getBaseDir(), "built.bin");
            boolean rebuild = !markerFile.exists();
            BuildSrcBuildListener listener = new BuildSrcBuildListener(rebuild);
            this.gradleLauncher.addListener(listener);
            this.gradleLauncher.run().rethrowFailure();
            Collection<File> classpath = listener.getRuntimeClasspath();
            LOGGER.debug("Gradle source classpath is: {}", classpath);
            LOGGER.info("================================================ Finished building buildSrc");
            try {
                markerFile.createNewFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return new DefaultClassPath(classpath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildSrcBuildListener
    extends BuildAdapter {
        private EmbeddableJavaProject projectInfo;
        private Set<File> classpath;
        private final boolean rebuild;

        public BuildSrcBuildListener(boolean rebuild) {
            this.rebuild = rebuild;
        }

        @Override
        public void projectsLoaded(Gradle gradle) {
            gradle.getRootProject().apply(WrapUtil.toMap("from", BuildSourceBuilder.getDefaultScript()));
        }

        @Override
        public void projectsEvaluated(Gradle gradle) {
            this.projectInfo = gradle.getRootProject().getConvention().getPlugin(EmbeddableJavaProject.class);
            gradle.getStartParameter().setTaskNames(this.rebuild ? this.projectInfo.getRebuildTasks() : this.projectInfo.getBuildTasks());
            this.classpath = this.projectInfo.getRuntimeClasspath().getFiles();
        }

        public Collection<File> getRuntimeClasspath() {
            return this.classpath;
        }
    }
}

