/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import org.gradle.api.GradleScriptException;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptExecutionListener;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.internal.ScriptRunnerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptRunnerFactory
implements ScriptRunnerFactory {
    private final ScriptExecutionListener listener;

    public DefaultScriptRunnerFactory(ScriptExecutionListener listener) {
        this.listener = listener;
    }

    @Override
    public <T extends Script> ScriptRunner<T> create(T script) {
        return new ScriptRunnerImpl(this, script);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptRunnerImpl<T extends Script>
    implements ScriptRunner<T> {
        private final T script;
        final /* synthetic */ DefaultScriptRunnerFactory this$0;

        public ScriptRunnerImpl(T script) {
            this.this$0 = var1_1;
            this.script = script;
        }

        @Override
        public T getScript() {
            return this.script;
        }

        @Override
        public void run() throws GradleScriptException {
            ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
            this.this$0.listener.beforeScript((Script)((Object)this.script));
            GradleScriptException failure = null;
            Thread.currentThread().setContextClassLoader(((Script)((Object)this.script)).getContextClassloader());
            ((Script)((Object)this.script)).getStandardOutputCapture().start();
            try {
                this.script.run();
            }
            catch (Throwable e) {
                failure = new GradleScriptException(String.format("A problem occurred evaluating %s.", this.script), e);
            }
            ((Script)((Object)this.script)).getStandardOutputCapture().stop();
            Thread.currentThread().setContextClassLoader(originalLoader);
            this.this$0.listener.afterScript((Script)((Object)this.script), failure);
            if (failure != null) {
                throw failure;
            }
        }
    }
}

