/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.api.specs.Spec;
import org.gradle.execution.taskgraph.DefaultTaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParallelTaskPlanExecutor
extends DefaultTaskPlanExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelTaskPlanExecutor.class);
    private final List<Thread> executorThreads = new ArrayList<Thread>();
    private final TaskArtifactStateCacheAccess stateCacheAccess;
    private final int executorCount;

    public ParallelTaskPlanExecutor(TaskArtifactStateCacheAccess cacheAccess, int numberOfParallelExecutors) {
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        LOGGER.info("Using {} parallel executor threads", (Object)numberOfParallelExecutors);
        this.stateCacheAccess = cacheAccess;
        this.executorCount = numberOfParallelExecutors;
    }

    @Override
    public void process(final TaskExecutionPlan taskExecutionPlan, final TaskExecutionListener taskListener) {
        this.stateCacheAccess.longRunningOperation("Executing all tasks", new Runnable(){

            public void run() {
                ParallelTaskPlanExecutor.this.doProcess(taskExecutionPlan, taskListener);
                taskExecutionPlan.awaitCompletion();
            }
        });
    }

    private void doProcess(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener) {
        List<Project> projects = this.getAllProjects(taskExecutionPlan);
        int numExecutors = Math.min(this.executorCount, projects.size());
        for (int i = 0; i < numExecutors; ++i) {
            TaskExecutorWorker worker = new TaskExecutorWorker(taskExecutionPlan, taskListener);
            for (int j = i; j < projects.size(); j += numExecutors) {
                worker.addProject(projects.get(j));
            }
            this.executorThreads.add(new Thread(worker));
        }
        for (Thread executorThread : this.executorThreads) {
            executorThread.start();
        }
    }

    private List<Project> getAllProjects(TaskExecutionPlan taskExecutionPlan) {
        LinkedHashSet<Project> uniqueProjects = new LinkedHashSet<Project>();
        for (Task task : taskExecutionPlan.getTasks()) {
            uniqueProjects.add(task.getProject());
        }
        return new ArrayList<Project>(uniqueProjects);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskExecutorWorker
    implements Runnable {
        private final TaskExecutionPlan taskExecutionPlan;
        private final TaskExecutionListener taskListener;
        private final List<Project> projects = new ArrayList<Project>();

        private TaskExecutorWorker(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener) {
            this.taskExecutionPlan = taskExecutionPlan;
            this.taskListener = taskListener;
        }

        @Override
        public void run() {
            TaskInfo taskInfo;
            while ((taskInfo = this.taskExecutionPlan.getTaskToExecute(this.getTaskSpec())) != null) {
                this.executeTaskWithCacheLock(taskInfo);
            }
            LOGGER.info(Thread.currentThread() + " stopping");
        }

        private void executeTaskWithCacheLock(final TaskInfo taskInfo) {
            String taskPath = taskInfo.getTask().getPath();
            LOGGER.info(taskPath + " (" + Thread.currentThread() + " - start");
            ParallelTaskPlanExecutor.this.stateCacheAccess.useCache("Executing " + taskPath, new Runnable(){

                public void run() {
                    ParallelTaskPlanExecutor.this.processTask(taskInfo, TaskExecutorWorker.this.taskExecutionPlan, TaskExecutorWorker.this.taskListener);
                }
            });
            LOGGER.info(taskPath + " (" + Thread.currentThread() + ") - complete");
        }

        public void addProject(Project project) {
            this.projects.add(project);
        }

        private Spec<TaskInfo> getTaskSpec() {
            return new Spec<TaskInfo>(){

                @Override
                public boolean isSatisfiedBy(TaskInfo element) {
                    return TaskExecutorWorker.this.projects.contains(element.getTask().getProject());
                }
            };
        }
    }
}

