/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultTaskExecutionPlan
implements TaskExecutionPlan {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final LinkedHashMap<Task, TaskInfo> executionPlan = new LinkedHashMap();
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private Spec<? super Task> filter = Specs.satisfyAll();
    private TaskFailureHandler failureHandler = new RethrowingFailureHandler();

    DefaultTaskExecutionPlan() {
    }

    public void addToTaskGraph(Collection<? extends Task> tasks) {
        ArrayList<? extends Task> queue = new ArrayList<Task>(tasks);
        Collections.sort(queue);
        HashSet<Task> visiting = new HashSet<Task>();
        CachingTaskDependencyResolveContext context = new CachingTaskDependencyResolveContext();
        while (!queue.isEmpty()) {
            Task task = (Task)queue.get(0);
            if (!this.filter.isSatisfiedBy(task)) {
                queue.remove(0);
                continue;
            }
            if (this.executionPlan.containsKey(task)) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(task)) {
                TreeSet dependsOnTasks = new TreeSet(Collections.reverseOrder());
                dependsOnTasks.addAll(context.getDependencies(task));
                for (Task task2 : dependsOnTasks) {
                    if (visiting.contains(task2)) {
                        throw new CircularReferenceException(String.format("Circular dependency between tasks. Cycle includes [%s, %s].", task, task2));
                    }
                    queue.add(0, task2);
                }
                continue;
            }
            queue.remove(0);
            visiting.remove(task);
            HashSet<TaskInfo> dependencies = new HashSet<TaskInfo>();
            for (Task task3 : context.getDependencies(task)) {
                TaskInfo dependencyInfo = this.executionPlan.get(task3);
                if (dependencyInfo == null) continue;
                dependencies.add(dependencyInfo);
            }
            this.executionPlan.put(task, new TaskInfo((TaskInternal)task, dependencies));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.executionPlan.clear();
            this.failures.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Task> getTasks() {
        return new ArrayList<Task>(this.executionPlan.keySet());
    }

    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    public void useFailureHandler(TaskFailureHandler handler) {
        this.failureHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskInfo getTaskToExecute(Spec<TaskInfo> criteria) {
        this.lock.lock();
        try {
            TaskInfo nextMatching;
            while ((nextMatching = this.getNextReadyAndMatching(criteria)) != null) {
                while (!nextMatching.allDependenciesComplete()) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!nextMatching.isReady()) continue;
                if (nextMatching.allDependenciesSuccessful()) {
                    nextMatching.startExecution();
                    TaskInfo taskInfo = nextMatching;
                    return taskInfo;
                }
                nextMatching.skipExecution();
                this.condition.signalAll();
            }
            TaskInfo taskInfo = null;
            return taskInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    private TaskInfo getNextReadyAndMatching(Spec<TaskInfo> criteria) {
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (!taskInfo.isReady() || !criteria.isSatisfiedBy(taskInfo)) continue;
            return taskInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskComplete(TaskInfo taskInfo) {
        this.lock.lock();
        try {
            if (taskInfo.isFailed()) {
                this.handleFailure(taskInfo);
            }
            taskInfo.finishExecution();
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleFailure(TaskInfo taskInfo) {
        Throwable executionFailure = taskInfo.getExecutionFailure();
        if (executionFailure != null) {
            this.abortExecution();
            this.failures.add(executionFailure);
            return;
        }
        try {
            this.failureHandler.onTaskFailure(taskInfo.getTask());
            this.failures.add(taskInfo.getTaskFailure());
        }
        catch (Exception e) {
            this.abortExecution();
            this.failures.add(e);
        }
    }

    private void abortExecution() {
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (!taskInfo.isReady()) continue;
            taskInfo.skipExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitCompletion() {
        this.lock.lock();
        try {
            while (!this.allTasksComplete()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.rethrowFailures();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void rethrowFailures() {
        if (this.failures.isEmpty()) {
            return;
        }
        if (this.failures.size() > 1) {
            throw new MultipleBuildFailures(this.failures);
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)this.failures.get(0));
    }

    private boolean allTasksComplete() {
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (taskInfo.isComplete()) continue;
            return false;
        }
        return true;
    }

    private static class RethrowingFailureHandler
    implements TaskFailureHandler {
        private RethrowingFailureHandler() {
        }

        public void onTaskFailure(Task task) {
            task.getState().rethrowFailure();
        }
    }
}

