/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.specs.Spec;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.TaskSelector;

public class ExcludedTaskFilteringBuildConfigurationAction
implements BuildConfigurationAction {
    private final TaskSelector selector;

    public ExcludedTaskFilteringBuildConfigurationAction() {
        this(new TaskSelector());
    }

    ExcludedTaskFilteringBuildConfigurationAction(TaskSelector taskSelector) {
        this.selector = taskSelector;
    }

    public void configure(BuildExecutionContext context) {
        GradleInternal gradle = context.getGradle();
        Set<String> excludedTaskNames = gradle.getStartParameter().getExcludedTaskNames();
        if (!excludedTaskNames.isEmpty()) {
            final HashSet<Task> excludedTasks = new HashSet<Task>();
            for (String taskName : excludedTaskNames) {
                this.selector.selectTasks(gradle, taskName);
                excludedTasks.addAll(this.selector.getTasks());
            }
            gradle.getTaskGraph().useFilter((Spec<? super Task>)new Spec<Task>(){

                @Override
                public boolean isSatisfiedBy(Task task) {
                    return !excludedTasks.contains(task);
                }
            });
        }
        context.proceed();
    }
}

