/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.gradle.configuration.ImportsScriptSource;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.UncheckedException;

public class ImportsReader {
    private String importsText;

    public String getImports() {
        if (this.importsText == null) {
            try {
                URL url = this.getClass().getResource("default-imports.txt");
                InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF8");
                int bufferSize = 2048;
                StringBuilder imports = new StringBuilder(bufferSize);
                char[] chars = new char[bufferSize];
                int numRead = reader.read(chars, 0, bufferSize);
                while (numRead != -1) {
                    imports.append(chars, 0, numRead);
                    numRead = reader.read(chars, 0, bufferSize);
                }
                this.importsText = imports.toString();
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return this.importsText;
    }

    public ScriptSource withImports(ScriptSource source) {
        return new ImportsScriptSource(source, this);
    }
}

