/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.FileIntegrityViolationException;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnDemandFileAccess
extends AbstractFileAccess {
    private final String displayName;
    private final FileLockManager manager;
    private final File targetFile;

    public OnDemandFileAccess(File targetFile, String displayName, FileLockManager manager) {
        this.targetFile = targetFile;
        this.displayName = displayName;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException, FileIntegrityViolationException {
        FileLock lock = this.manager.lock(this.targetFile, FileLockManager.LockMode.Shared, this.displayName);
        try {
            T t = lock.readFile(action);
            return t;
        }
        finally {
            lock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFile(Runnable action) throws LockTimeoutException, FileIntegrityViolationException {
        FileLock lock = this.manager.lock(this.targetFile, FileLockManager.LockMode.Exclusive, this.displayName);
        try {
            lock.updateFile(action);
        }
        finally {
            lock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(Runnable action) throws LockTimeoutException {
        FileLock lock = this.manager.lock(this.targetFile, FileLockManager.LockMode.Exclusive, this.displayName);
        try {
            lock.writeFile(action);
        }
        finally {
            lock.close();
        }
    }
}

