/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryCache;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.Factory;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateOnDemandPersistentDirectoryCache
implements ReferencablePersistentCache {
    private DefaultPersistentDirectoryCache delegateCache;
    private boolean isOpen;

    public DelegateOnDemandPersistentDirectoryCache(DefaultPersistentDirectoryCache cache) {
        this.delegateCache = cache;
    }

    @Override
    public DelegateOnDemandPersistentDirectoryCache open() {
        this.isOpen = true;
        return this;
    }

    @Override
    public void close() {
        this.isOpen = false;
        this.delegateCache.close();
    }

    @Override
    public FileLock getLock() {
        return this.delegateCache.getLock();
    }

    @Override
    public <T> T useCache(final String operationDisplayName, final Factory<? extends T> action) {
        return this.runWithOpenedCache(new Factory<T>(){

            public T create() {
                return DelegateOnDemandPersistentDirectoryCache.this.delegateCache.useCache(operationDisplayName, action);
            }
        });
    }

    @Override
    public void useCache(final String operationDisplayName, final Runnable action) {
        this.runWithOpenedCache(new Factory<Void>(){

            public Void create() {
                DelegateOnDemandPersistentDirectoryCache.this.delegateCache.useCache(operationDisplayName, action);
                return null;
            }
        });
    }

    @Override
    public <T> T longRunningOperation(final String operationDisplayName, final Factory<? extends T> action) {
        return this.runWithOpenedCache(new Factory<T>(){

            public T create() {
                return DelegateOnDemandPersistentDirectoryCache.this.delegateCache.longRunningOperation(operationDisplayName, action);
            }
        });
    }

    @Override
    public void longRunningOperation(final String operationDisplayName, final Runnable action) {
        this.runWithOpenedCache(new Factory<Void>(){

            public Void create() {
                DelegateOnDemandPersistentDirectoryCache.this.delegateCache.longRunningOperation(operationDisplayName, action);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runWithOpenedCache(Factory<T> factory) {
        if (this.isOpen) {
            this.delegateCache.open();
            try {
                Object object = factory.create();
                return (T)object;
            }
            finally {
                this.delegateCache.close();
            }
        }
        throw new CacheOpenException("Cannot run operation on cache that has not been opened.");
    }

    @Override
    public File getBaseDir() {
        return this.delegateCache.getBaseDir();
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(File cacheFile, Class<K> keyType, Class<V> valueType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(File cacheFile, Class<K> keyType, Serializer<V> valueSerializer) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("On Demand Cache for %s", this.delegateCache.toString());
    }
}

