/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.dependencies;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedModuleVersionResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedModuleVersionResult;
import org.gradle.api.tasks.diagnostics.internal.dependencies.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.dependencies.RenderableDependencyResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderableModuleResult
implements RenderableDependency {
    private final ResolvedModuleVersionResult module;

    public RenderableModuleResult(ResolvedModuleVersionResult module) {
        this.module = module;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.module.getId();
    }

    @Override
    public String getName() {
        return this.module.getId().getGroup() + ":" + this.module.getId().getName() + ":" + this.module.getId().getVersion();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public Set<RenderableDependency> getChildren() {
        return new LinkedHashSet<RenderableDependency>(Collections2.transform(this.module.getDependencies(), (Function)new Function<ResolvedDependencyResult, RenderableDependency>(){

            public RenderableDependency apply(ResolvedDependencyResult input) {
                return new RenderableDependencyResult(input);
            }
        }));
    }

    @Override
    public Set<RenderableDependency> getParents() {
        return new LinkedHashSet<RenderableDependency>(Collections2.transform(((DefaultResolvedModuleVersionResult)this.module).getDependees(), (Function)new Function<ResolvedModuleVersionResult, RenderableDependency>(){

            public RenderableDependency apply(ResolvedModuleVersionResult input) {
                return new RenderableModuleResult(input);
            }
        }));
    }
}

