/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.dependencies;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedModuleVersionResult;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.result.DefaultResolvedModuleVersionResult;
import org.gradle.api.tasks.diagnostics.internal.dependencies.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.dependencies.RenderableModuleResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderableDependencyResult
implements RenderableDependency {
    private final ResolvedDependencyResult dependency;
    private final String description;

    public RenderableDependencyResult(ResolvedDependencyResult dependency) {
        this(dependency, null);
    }

    public RenderableDependencyResult(ResolvedDependencyResult dependency, String description) {
        this.dependency = dependency;
        this.description = description;
    }

    @Override
    public String getName() {
        if (!RenderableDependencyResult.requestedEqualsSelected(this.dependency)) {
            return this.requested() + " -> " + this.dependency.getSelected().getId().getVersion();
        }
        return this.requested();
    }

    private static boolean requestedEqualsSelected(ResolvedDependencyResult dependency) {
        return DefaultModuleVersionIdentifier.newId(dependency.getRequested()).equals(dependency.getSelected().getId());
    }

    private String requested() {
        return this.dependency.getRequested().getGroup() + ":" + this.dependency.getRequested().getName() + ":" + this.dependency.getRequested().getVersion();
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.dependency.getSelected().getId();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<RenderableDependency> getChildren() {
        return new LinkedHashSet<RenderableDependency>(Collections2.transform(this.dependency.getSelected().getDependencies(), (Function)new Function<ResolvedDependencyResult, RenderableDependency>(){

            public RenderableDependency apply(ResolvedDependencyResult input) {
                return new RenderableDependencyResult(input);
            }
        }));
    }

    @Override
    public Set<RenderableDependency> getParents() {
        return new LinkedHashSet<RenderableDependency>(Collections2.transform(((DefaultResolvedModuleVersionResult)this.dependency.getSelected()).getDependees(), (Function)new Function<ResolvedModuleVersionResult, RenderableDependency>(){

            public RenderableDependency apply(ResolvedModuleVersionResult input) {
                return new RenderableModuleResult(input);
            }
        }));
    }
}

