/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizReportRenderer
extends TextReportRenderer
implements DependencyReportRenderer {
    @Override
    public void startProject(Project project) {
    }

    @Override
    public void startConfiguration(Configuration configuration) {
    }

    @Override
    public void completeConfiguration(Configuration configuration) {
    }

    @Override
    public void render(Configuration conf) throws IOException {
        ResolvedConfiguration resolvedConfiguration = conf.getResolvedConfiguration();
        this.getTextOutput().println("digraph SomeConf{");
        HashSet<String> edges = new HashSet<String>();
        for (ResolvedDependency resolvedDependency : resolvedConfiguration.getFirstLevelModuleDependencies()) {
            this.buildDotDependencyTree(resolvedDependency, edges);
        }
        for (String edge : edges) {
            this.getTextOutput().println(edge);
        }
        this.getTextOutput().println("}");
    }

    private void buildDotDependencyTree(ResolvedDependency root, Set<String> edges) {
        if (root.getAllModuleArtifacts().isEmpty()) {
            return;
        }
        for (ResolvedDependency dep : root.getChildren()) {
            String edge = "\"" + root.toString() + "\" -> \"" + dep.toString().replace('-', '_') + "\";";
            edges.add(edge);
        }
        for (ResolvedDependency dep : root.getChildren()) {
            this.buildDotDependencyTree(dep, edges);
        }
    }
}

