/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.GraphRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.dependencies.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.dependencies.RenderableModuleResult;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiReportRenderer
extends TextReportRenderer
implements DependencyReportRenderer {
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;

    @Override
    public void startProject(Project project) {
        super.startProject(project);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    @Override
    public void completeProject(Project project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println("No configurations");
        }
        super.completeProject(project);
    }

    @Override
    public void startConfiguration(final Configuration configuration) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text(configuration.getName());
                AsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text(AsciiReportRenderer.this.getDescription(configuration));
            }
        }, true);
    }

    private String getDescription(Configuration configuration) {
        return GUtil.isTrue(configuration.getDescription()) ? " - " + configuration.getDescription() : "";
    }

    @Override
    public void completeConfiguration(Configuration configuration) {
    }

    @Override
    public void render(Configuration configuration) throws IOException {
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        ResolutionResult result = resolvedConfiguration.getResolutionResult();
        RenderableModuleResult root = new RenderableModuleResult(result.getRoot());
        this.renderNow(root);
        resolvedConfiguration.rethrowFailure();
    }

    void renderNow(RenderableDependency root) {
        if (root.getChildren().isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text("No dependencies");
            this.getTextOutput().println();
            return;
        }
        this.renderChildren(root.getChildren(), new HashSet<ModuleVersionIdentifier>());
    }

    @Override
    public void complete() throws IOException {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println("\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(final RenderableDependency resolvedDependency, Set<ModuleVersionIdentifier> visitedDependencyNames, boolean lastChild) {
        final boolean isFirstVisitOfDependencyInConfiguration = visitedDependencyNames.add(resolvedDependency.getId());
        if (!isFirstVisitOfDependencyInConfiguration) {
            this.hasCyclicDependencies = true;
        }
        this.renderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AsciiReportRenderer.this.getTextOutput().text(resolvedDependency.getName());
                StyledTextOutput infoStyle = AsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Info);
                if (!isFirstVisitOfDependencyInConfiguration) {
                    infoStyle.append(" (*)");
                }
            }
        }, lastChild);
        if (isFirstVisitOfDependencyInConfiguration) {
            this.renderChildren(resolvedDependency.getChildren(), visitedDependencyNames);
        }
    }

    private void renderChildren(Set<RenderableDependency> children, Set<ModuleVersionIdentifier> visitedDependencyNames) {
        this.renderer.startChildren();
        ArrayList<RenderableDependency> mergedChildren = new ArrayList<RenderableDependency>(children);
        for (int i = 0; i < mergedChildren.size(); ++i) {
            RenderableDependency dependency = (RenderableDependency)mergedChildren.get(i);
            this.render(dependency, visitedDependencyNames, i == mergedChildren.size() - 1);
        }
        this.renderer.completeChildren();
    }
}

