/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.AsciiReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyReportTask
extends AbstractReportTask {
    private DependencyReportRenderer renderer = new AsciiReportRenderer();
    private Set<Configuration> configurations;

    @Override
    public ReportRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DependencyReportRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void generate(Project project) throws IOException {
        TreeSet<Configuration> sortedConfigurations = new TreeSet<Configuration>(new Comparator<Configuration>(){

            @Override
            public int compare(Configuration conf1, Configuration conf2) {
                return conf1.getName().compareTo(conf2.getName());
            }
        });
        sortedConfigurations.addAll(this.getConfigurations(project));
        for (Configuration configuration : sortedConfigurations) {
            this.renderer.startConfiguration(configuration);
            this.renderer.render(configuration);
            this.renderer.completeConfiguration(configuration);
        }
    }

    private Set<Configuration> getConfigurations(Project project) {
        return this.configurations != null ? this.configurations : project.getConfigurations();
    }

    public Set<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Set<Configuration> configurations) {
        this.configurations = configurations;
    }
}

