/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskContainer
extends DefaultTaskCollection<Task>
implements TaskContainerInternal {
    private final ITaskFactory taskFactory;

    public DefaultTaskContainer(ProjectInternal project, Instantiator instantiator, ITaskFactory taskFactory) {
        super(Task.class, instantiator, project);
        this.taskFactory = taskFactory;
    }

    @Override
    public Task add(Map<String, ?> options) {
        HashMap mutableOptions = new HashMap(options);
        Object replaceStr = mutableOptions.remove("overwrite");
        boolean replace = replaceStr != null && "true".equals(replaceStr.toString());
        TaskInternal task = this.taskFactory.createTask(mutableOptions);
        String name = task.getName();
        Task existing = (Task)this.findByNameWithoutRules(name);
        if (existing != null) {
            if (replace) {
                this.remove(existing);
            } else {
                throw new InvalidUserDataException(String.format("Cannot add %s as a task with that name already exists.", task));
            }
        }
        this.add(task);
        return task;
    }

    @Override
    public Task add(Map<String, ?> options, Closure configureClosure) throws InvalidUserDataException {
        return this.add(options).configure(configureClosure);
    }

    @Override
    public <T extends Task> T add(String name, Class<T> type) {
        return (T)((Task)type.cast(this.add(GUtil.map("name", name, "type", type))));
    }

    @Override
    public Task create(String name) {
        return this.add(name);
    }

    @Override
    public Task add(String name) {
        return this.add(GUtil.map("name", name));
    }

    @Override
    public Task replace(String name) {
        return this.add(GUtil.map("name", name, "overwrite", true));
    }

    @Override
    public Task create(String name, Closure configureClosure) {
        return this.add(name, configureClosure);
    }

    @Override
    public Task add(String name, Closure configureClosure) {
        return this.add(GUtil.map("name", name)).configure(configureClosure);
    }

    @Override
    public <T extends Task> T replace(String name, Class<T> type) {
        return (T)((Task)type.cast(this.add(GUtil.map("name", name, "type", type, "overwrite", true))));
    }

    @Override
    public Task findByPath(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!path.contains(":")) {
            return (Task)this.findByName(path);
        }
        String projectPath = StringUtils.substringBeforeLast((String)path, (String)":");
        ProjectInternal project = this.project.findProject(!GUtil.isTrue(projectPath) ? ":" : projectPath);
        if (project == null) {
            return null;
        }
        return (Task)project.getTasks().findByName(StringUtils.substringAfterLast((String)path, (String)":"));
    }

    @Override
    public Task resolveTask(Object path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!(path instanceof CharSequence)) {
            DeprecationLogger.nagUserWith(String.format("Converting class %s to a task dependency using toString(). This has been deprecated and will be removed in the next version of Gradle. Please use org.gradle.api.Task, java.lang.String, org.gradle.api.Buildable, org.gradle.tasks.TaskDependency or a Closure to declare your task dependencies.", path.getClass().getName()));
        }
        return this.getByPath(path.toString());
    }

    @Override
    public Task getByPath(String path) throws UnknownTaskException {
        Task task = this.findByPath(path);
        if (task == null) {
            throw new UnknownTaskException(String.format("Task with path '%s' not found in %s.", path, this.project));
        }
        return task;
    }

    protected Object createConfigureDelegate(Closure configureClosure) {
        return new NamedDomainObjectContainerConfigureDelegate(configureClosure.getOwner(), this);
    }

    @Override
    public TaskContainerInternal configure(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.createConfigureDelegate(configureClosure));
        return this;
    }

    @Override
    public DynamicObject getTasksAsDynamicObject() {
        return this.getElementsAsDynamicObject();
    }
}

