/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import groovy.lang.MissingPropertyException;
import java.util.Map;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraPropertiesDynamicObjectAdapter
extends BeanDynamicObject {
    private final ExtraPropertiesExtension extension;
    private final Object delegate;
    private final DynamicObject dynamicOwner;

    public ExtraPropertiesDynamicObjectAdapter(Object delegate, DynamicObject dynamicOwner, ExtraPropertiesExtension extension) {
        super(extension);
        this.delegate = delegate;
        this.dynamicOwner = dynamicOwner;
        this.extension = extension;
    }

    @Override
    public boolean hasProperty(String name) {
        return super.hasProperty(name) || this.extension.has(name);
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.extension.getProperties();
    }

    @Override
    public void setProperty(String name, Object value) throws MissingPropertyException {
        if (!this.dynamicOwner.hasProperty(name)) {
            DeprecationLogger.nagUserAboutDynamicProperty(name, this.delegate, value);
        }
        super.setProperty(name, value);
    }
}

