/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionsStorage {
    private final Map<String, Object> extensions = new LinkedHashMap<String, Object>();

    public void add(String name, Object extension) {
        if (this.extensions.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Cannot add extension with name '%s', as there is an extension already registered with that name.", name));
        }
        this.extensions.put(name, extension);
    }

    public boolean hasExtension(String name) {
        return this.extensions.containsKey(name);
    }

    public Map<String, Object> getAsMap() {
        return this.extensions;
    }

    public void checkExtensionIsNotReassigned(String name) {
        if (this.hasExtension(name)) {
            throw new IllegalArgumentException(String.format("There's an extension registered with name '%s'. You should not reassign it via a property setter.", name));
        }
    }

    public boolean isConfigureExtensionMethod(String methodName, Object ... arguments) {
        return this.extensions.containsKey(methodName) && arguments.length == 1 && arguments[0] instanceof Closure;
    }

    public Object configureExtension(String methodName, Object ... arguments) {
        return ConfigureUtil.configure((Closure)arguments[0], this.extensions.get(methodName));
    }

    public <T> T getByType(Class<T> type) {
        Collection<Object> values = this.extensions.values();
        LinkedList<String> types = new LinkedList<String>();
        for (Object e : values) {
            Class<?> clazz = e.getClass();
            types.add(clazz.getSimpleName());
            if (!type.isAssignableFrom(clazz)) continue;
            return (T)e;
        }
        throw new UnknownDomainObjectException("Extension of type '" + type.getSimpleName() + "' does not exist. Currently registered extension types: " + types);
    }

    public <T> T findByType(Class<T> type) {
        Collection<Object> values = this.extensions.values();
        for (Object e : values) {
            if (!type.isAssignableFrom(e.getClass())) continue;
            return (T)e;
        }
        return null;
    }

    public Object getByName(String name) {
        if (!this.hasExtension(name)) {
            throw new UnknownDomainObjectException("Extension with name '" + name + "' does not exist. Currently registered extension names: " + this.extensions.keySet());
        }
        return this.extensions.get(name);
    }

    public Object findByName(String name) {
        return this.extensions.get(name);
    }
}

