/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.filestore;

import java.io.File;
import java.util.UUID;
import org.gradle.api.internal.filestore.FileStore;
import org.gradle.api.internal.filestore.FileStoreEntry;
import org.gradle.api.internal.filestore.PathKeyFileStore;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUIDFileStore
implements FileStore<String> {
    private final PathKeyFileStore delegate;
    private final Factory<UUID> uuidFactory;

    public UUIDFileStore(PathKeyFileStore delegate) {
        this(delegate, new Factory<UUID>(){

            public UUID create() {
                return UUID.randomUUID();
            }
        });
    }

    UUIDFileStore(PathKeyFileStore delegate, Factory<UUID> uuidFactory) {
        this.delegate = delegate;
        this.uuidFactory = uuidFactory;
    }

    @Override
    public FileStoreEntry move(String dir, File source) {
        return this.delegate.move(this.getPath(dir), source);
    }

    @Override
    public FileStoreEntry copy(String dir, File source) {
        return this.delegate.copy(this.getPath(dir), source);
    }

    private String getPath(String dir) {
        return String.format("%s/%s", dir, this.uuidFactory.create());
    }

    @Override
    public File getTempFile() {
        return this.delegate.getTempFile();
    }

    @Override
    public void moveFilestore(File destination) {
        this.delegate.moveFilestore(destination);
    }
}

