/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.filestore;

import java.io.File;
import java.util.Set;
import org.gradle.api.internal.filestore.FileStore;
import org.gradle.api.internal.filestore.FileStoreEntry;
import org.gradle.api.internal.filestore.FileStoreSearcher;
import org.gradle.api.internal.filestore.PathKeyFileStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathNormalisingKeyFileStore
implements FileStore<String>,
FileStoreSearcher<String> {
    private final PathKeyFileStore delegate;

    public PathNormalisingKeyFileStore(File baseDir) {
        this(new PathKeyFileStore(baseDir));
    }

    public PathNormalisingKeyFileStore(PathKeyFileStore delegate) {
        this.delegate = delegate;
    }

    @Override
    public FileStoreEntry move(String key, File source) {
        return this.delegate.move(this.normalizePath(key), source);
    }

    @Override
    public FileStoreEntry copy(String key, File source) {
        return this.delegate.copy(key, source);
    }

    protected String normalizePath(String path) {
        return path.replaceAll("[^\\d\\w\\./]", "_");
    }

    protected String normalizeSearchPath(String path) {
        return path.replaceAll("[^\\d\\w\\.\\*/]", "_");
    }

    @Override
    public File getTempFile() {
        return this.delegate.getTempFile();
    }

    @Override
    public void moveFilestore(File destination) {
        this.delegate.moveFilestore(destination);
    }

    @Override
    public Set<? extends FileStoreEntry> search(String key) {
        return this.delegate.search(this.normalizeSearchPath(key));
    }
}

