/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.filestore;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.copy.DeleteActionImpl;
import org.gradle.api.internal.filestore.AbstractFileStoreEntry;
import org.gradle.api.internal.filestore.FileStore;
import org.gradle.api.internal.filestore.FileStoreEntry;
import org.gradle.api.internal.filestore.FileStoreSearcher;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathKeyFileStore
implements FileStore<String>,
FileStoreSearcher<String> {
    private final Random generator = new Random(System.currentTimeMillis());
    private File baseDir;
    private final DeleteActionImpl deleteAction = new DeleteActionImpl(new IdentityFileResolver());

    public PathKeyFileStore(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public FileStoreEntry move(String path, File source) {
        return this.saveIntoFileStore(source, this.getFile(path), true);
    }

    @Override
    public FileStoreEntry copy(String path, File source) {
        return this.saveIntoFileStore(source, this.getFile(path), false);
    }

    private File getFile(String path) {
        return new File(this.baseDir, path);
    }

    @Override
    public File getTempFile() {
        long tempLong = this.generator.nextLong();
        tempLong = tempLong < 0L ? -tempLong : tempLong;
        return new File(this.baseDir, "temp/" + tempLong);
    }

    @Override
    public void moveFilestore(File destination) {
        if (this.baseDir.exists()) {
            try {
                FileUtils.moveDirectory((File)this.baseDir, (File)destination);
            }
            catch (IOException e) {
                throw new UncheckedException((Throwable)e);
            }
        }
        this.baseDir = destination;
    }

    protected FileStoreEntry saveIntoFileStore(File source, File destination, boolean isMove) {
        if (!source.exists()) {
            throw new GradleException(String.format("Cannot copy '%s' into filestore @ '%s' as it does not exist", source, destination));
        }
        File parentDir = destination.getParentFile();
        if (!parentDir.mkdirs() && !parentDir.exists()) {
            throw new GradleException(String.format("Unable to create filestore directory %s", parentDir));
        }
        String verb = isMove ? "move" : "copy";
        try {
            this.deleteAction.delete(destination);
            if (isMove) {
                FileUtils.moveFile((File)source, (File)destination);
            } else {
                FileUtils.copyFile((File)source, (File)destination);
            }
        }
        catch (IOException e) {
            throw new GradleException(String.format("Failed to %s file '%s' into filestore at '%s' ", verb, source, destination), e);
        }
        return this.entryAt(destination);
    }

    @Override
    public Set<? extends FileStoreEntry> search(String pattern) {
        final HashSet entries = new HashSet();
        this.findFiles(pattern).visit(new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                entries.add(PathKeyFileStore.this.entryAt(fileDetails.getFile()));
            }
        });
        return entries;
    }

    private DirectoryFileTree findFiles(String pattern) {
        DirectoryFileTree fileTree = new DirectoryFileTree(this.baseDir);
        PatternSet patternSet = new PatternSet();
        patternSet.include(pattern);
        return fileTree.filter(patternSet);
    }

    protected FileStoreEntry entryAt(File file) {
        return this.entryAt(GFileUtils.relativePath(this.baseDir, file));
    }

    protected FileStoreEntry entryAt(final String path) {
        return new AbstractFileStoreEntry(){

            public File getFile() {
                return new File(PathKeyFileStore.this.baseDir, path);
            }
        };
    }
}

