/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.filestore;

import java.io.File;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.internal.filestore.FileStore;
import org.gradle.api.internal.filestore.FileStoreEntry;
import org.gradle.api.internal.filestore.FileStoreSearcher;
import org.gradle.api.internal.filestore.PathKeyFileStore;
import org.gradle.util.hash.HashUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedAndNamedUniqueFileStore<K>
implements FileStore<K>,
FileStoreSearcher<K> {
    private PathKeyFileStore delegate;
    private final Transformer<String, K> grouper;
    private final Transformer<String, K> namer;

    public GroupedAndNamedUniqueFileStore(PathKeyFileStore delegate, Transformer<String, K> grouper, Transformer<String, K> namer) {
        this.delegate = delegate;
        this.grouper = grouper;
        this.namer = namer;
    }

    @Override
    public FileStoreEntry move(K key, File source) {
        return this.delegate.move(this.toPath(key, this.getChecksum(source)), source);
    }

    @Override
    public FileStoreEntry copy(K key, File source) {
        return this.delegate.copy(this.toPath(key, this.getChecksum(source)), source);
    }

    @Override
    public Set<? extends FileStoreEntry> search(K key) {
        return this.delegate.search(this.toPath(key, "*"));
    }

    protected String toPath(K key, String checksumPart) {
        String group = this.grouper.transform(key);
        String name = this.namer.transform(key);
        return String.format("%s/%s/%s", group, checksumPart, name);
    }

    private String getChecksum(File contentFile) {
        return HashUtil.createHash(contentFile, "SHA1").asHexString();
    }

    @Override
    public File getTempFile() {
        return this.delegate.getTempFile();
    }

    @Override
    public void moveFilestore(File destination) {
        this.delegate.moveFilestore(destination);
    }
}

