/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.ContentFilterable;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.copy.CopySpecVisitor;
import org.gradle.api.internal.file.copy.DelegatingCopySpecVisitor;
import org.gradle.api.internal.file.copy.FilterChain;
import org.gradle.api.internal.file.copy.ReadableCopySpec;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;

public class MappingCopySpecVisitor
extends DelegatingCopySpecVisitor {
    private ReadableCopySpec spec;
    private FileSystem fileSystem;

    public MappingCopySpecVisitor(CopySpecVisitor visitor, FileSystem fileSystem) {
        super(visitor);
        this.fileSystem = fileSystem;
    }

    public void visitSpec(ReadableCopySpec spec) {
        this.spec = spec;
        this.getVisitor().visitSpec(spec);
    }

    public void visitDir(FileVisitDetails dirDetails) {
        this.getVisitor().visitDir(new FileVisitDetailsImpl(dirDetails, this.spec, this.fileSystem));
    }

    public void visitFile(FileVisitDetails fileDetails) {
        FileVisitDetailsImpl details = new FileVisitDetailsImpl(fileDetails, this.spec, this.fileSystem);
        for (Action<? super FileCopyDetails> action : this.spec.getAllCopyActions()) {
            action.execute((Object)details);
            if (!details.excluded) continue;
            return;
        }
        this.getVisitor().visitFile(details);
    }

    private static class ByteCountingOutputStream
    extends OutputStream {
        long size;

        private ByteCountingOutputStream() {
        }

        public void write(int b) throws IOException {
            ++this.size;
        }

        public void write(byte[] b) throws IOException {
            this.size += (long)b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.size += (long)len;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileVisitDetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails,
    FileCopyDetails {
        private final FileVisitDetails fileDetails;
        private final ReadableCopySpec spec;
        private FileSystem fileSystem;
        private final FilterChain filterChain = new FilterChain();
        private RelativePath relativePath;
        private boolean excluded;
        private Integer mode;

        public FileVisitDetailsImpl(FileVisitDetails fileDetails, ReadableCopySpec spec, FileSystem fileSystem) {
            this.fileDetails = fileDetails;
            this.spec = spec;
            this.fileSystem = fileSystem;
        }

        @Override
        public String getDisplayName() {
            return this.fileDetails.toString();
        }

        @Override
        public void stopVisiting() {
            this.fileDetails.stopVisiting();
        }

        @Override
        public File getFile() {
            if (this.filterChain.hasFilters()) {
                throw new UnsupportedOperationException();
            }
            return this.fileDetails.getFile();
        }

        @Override
        public boolean isDirectory() {
            return this.fileDetails.isDirectory();
        }

        @Override
        public long getLastModified() {
            return this.fileDetails.getLastModified();
        }

        @Override
        public long getSize() {
            if (this.filterChain.hasFilters()) {
                ByteCountingOutputStream outputStream = new ByteCountingOutputStream();
                this.copyTo(outputStream);
                return outputStream.size;
            }
            return this.fileDetails.getSize();
        }

        @Override
        public InputStream open() {
            if (this.filterChain.hasFilters()) {
                return this.filterChain.transform(this.fileDetails.open());
            }
            return this.fileDetails.open();
        }

        @Override
        public void copyTo(OutputStream outstr) {
            if (this.filterChain.hasFilters()) {
                super.copyTo(outstr);
            } else {
                this.fileDetails.copyTo(outstr);
            }
        }

        @Override
        public boolean copyTo(File target) {
            if (this.filterChain.hasFilters()) {
                return super.copyTo(target);
            }
            boolean copied = this.fileDetails.copyTo(target);
            this.adaptPermissions(target);
            return copied;
        }

        private void adaptPermissions(File target) {
            Integer specMode = this.getMode();
            if (specMode != null) {
                try {
                    this.fileSystem.chmod(target, specMode.intValue());
                }
                catch (IOException e) {
                    throw new GradleException(String.format("Could not set permission %s on '%s'.", specMode, target), e);
                }
            }
        }

        @Override
        public RelativePath getRelativePath() {
            if (this.relativePath == null) {
                RelativePath path = this.fileDetails.getRelativePath();
                this.relativePath = this.spec.getDestPath().append(path.isFile(), path.getSegments());
            }
            return this.relativePath;
        }

        @Override
        public int getMode() {
            if (this.mode != null) {
                return this.mode;
            }
            Integer specMode = this.getSpecMode();
            if (specMode != null) {
                return specMode;
            }
            return this.fileDetails.getMode();
        }

        private Integer getSpecMode() {
            return this.fileDetails.isDirectory() ? this.spec.getDirMode() : this.spec.getFileMode();
        }

        @Override
        public void setRelativePath(RelativePath path) {
            this.relativePath = path;
        }

        @Override
        public void setName(String name) {
            this.relativePath = this.getRelativePath().replaceLastName(name);
        }

        @Override
        public void setPath(String path) {
            this.relativePath = RelativePath.parse(this.getRelativePath().isFile(), path);
        }

        @Override
        public void exclude() {
            this.excluded = true;
        }

        @Override
        public void setMode(int mode) {
            this.mode = mode;
        }

        @Override
        public ContentFilterable filter(Closure closure) {
            this.filterChain.add(closure);
            return this;
        }

        @Override
        public ContentFilterable filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
            this.filterChain.add(filterType, properties);
            return this;
        }

        @Override
        public ContentFilterable filter(Class<? extends FilterReader> filterType) {
            this.filterChain.add(filterType);
            return this;
        }

        @Override
        public ContentFilterable expand(Map<String, ?> properties) {
            this.filterChain.expand(properties);
            return this;
        }
    }
}

