/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.compression;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.gradle.api.internal.file.archive.compression.Compressor;
import org.gradle.api.internal.resources.URIBuilder;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceException;

public class Bzip2Archiver
implements ReadableResource {
    private final ReadableResource resource;
    private final URI uri;

    public Bzip2Archiver(ReadableResource resource) {
        assert (resource != null);
        this.resource = resource;
        this.uri = new URIBuilder(resource.getURI()).schemePrefix("bzip2:").build();
    }

    public static Compressor getCompressor() {
        return new Compressor(){

            public OutputStream compress(File destination) {
                try {
                    FileOutputStream outStr = new FileOutputStream(destination);
                    ((OutputStream)outStr).write(66);
                    ((OutputStream)outStr).write(90);
                    return new CBZip2OutputStream((OutputStream)outStr);
                }
                catch (Exception e) {
                    String message = String.format("Unable to create bzip2 output stream for file %s", destination);
                    throw new RuntimeException(message, e);
                }
            }
        };
    }

    public InputStream read() {
        InputStream is = this.resource.read();
        try {
            byte[] skip = new byte[2];
            is.read(skip);
            return new CBZip2InputStream(is);
        }
        catch (Exception e) {
            String message = String.format("Unable to create bzip2 input stream for resource %s.", this.resource.getDisplayName());
            throw new ResourceException(message, e);
        }
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public URI getURI() {
        return this.uri;
    }

    public String getBaseName() {
        return this.resource.getBaseName();
    }
}

